/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.resolver;

import java.net.URI;
import javax.inject.Inject;
import pl.allegro.tech.hermes.api.EndpointAddress;
import pl.allegro.tech.hermes.api.EndpointAddressResolverMetadata;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.interpolation.InterpolationException;
import pl.allegro.tech.hermes.consumers.consumer.interpolation.UriInterpolator;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolutionException;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolver;

public class InterpolatingEndpointAddressResolver
implements EndpointAddressResolver {
    private final UriInterpolator interpolator;

    @Inject
    public InterpolatingEndpointAddressResolver(UriInterpolator interpolator) {
        this.interpolator = interpolator;
    }

    @Override
    public URI resolve(EndpointAddress address, Message message, EndpointAddressResolverMetadata metadata) throws EndpointAddressResolutionException {
        try {
            return this.interpolator.interpolate(address, message);
        }
        catch (InterpolationException ex) {
            throw new EndpointAddressResolutionException(address, (Throwable)ex);
        }
    }
}

