/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.resolver;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import pl.allegro.tech.hermes.api.EndpointAddress;
import pl.allegro.tech.hermes.api.EndpointAddressResolverMetadata;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.batch.MessageBatch;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolutionException;

public interface EndpointAddressResolver {
    default public URI resolve(EndpointAddress address, Message message, EndpointAddressResolverMetadata metadata) throws EndpointAddressResolutionException {
        return EndpointAddressResolver.resolve(address);
    }

    default public URI resolve(EndpointAddress address, MessageBatch batch, EndpointAddressResolverMetadata metadata) throws EndpointAddressResolutionException {
        return EndpointAddressResolver.resolve(address);
    }

    default public List<URI> resolveAll(EndpointAddress address, Message message, EndpointAddressResolverMetadata metadata) throws EndpointAddressResolutionException {
        return Collections.singletonList(this.resolve(address, message, metadata));
    }

    public static URI resolve(EndpointAddress address) throws EndpointAddressResolutionException {
        try {
            return address.getUri();
        }
        catch (Exception ex) {
            throw new EndpointAddressResolutionException(address, (Throwable)ex);
        }
    }
}

