/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.health;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Arrays;
import javax.ws.rs.core.Response;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.health.ConsumerMonitor;

public class ConsumerHttpServer {
    private final HttpServer server;
    private final ObjectMapper mapper;
    private static final String STATUS_UP = "{\"status\": \"UP\"}";

    public ConsumerHttpServer(ConfigFactory configFactory, ConsumerMonitor monitor, ObjectMapper mapper) throws IOException {
        this.mapper = mapper;
        this.server = this.createServer(configFactory.getIntProperty(Configs.CONSUMER_HEALTH_CHECK_PORT));
        this.server.createContext("/status/health", exchange -> ConsumerHttpServer.respondWithString(exchange, STATUS_UP));
        this.server.createContext("/status/subscriptions", exchange -> ConsumerHttpServer.respondWithObject(exchange, mapper, monitor.check("subscriptions")));
        this.server.createContext("/status/subscriptionsCount", exchange -> ConsumerHttpServer.respondWithObject(exchange, mapper, monitor.check("subscriptionsCount")));
    }

    private HttpServer createServer(int port) throws IOException {
        HttpServer httpServer = HttpServer.create(new InetSocketAddress(port), 0);
        httpServer.setExecutor(null);
        return httpServer;
    }

    private static void respondWithObject(HttpExchange httpExchange, ObjectMapper mapper, Object response) throws IOException {
        ConsumerHttpServer.respondWithString(httpExchange, mapper.writeValueAsString(response));
    }

    private static void respondWithString(HttpExchange httpExchange, String response) throws IOException {
        httpExchange.getResponseHeaders().put("Content-Type", Arrays.asList("application/json"));
        httpExchange.sendResponseHeaders(Response.Status.OK.getStatusCode(), response.length());
        OutputStream os = httpExchange.getResponseBody();
        os.write(response.getBytes());
        os.close();
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        this.server.stop(0);
    }
}

