/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.message.undelivered;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.message.undelivered.UndeliveredMessageLog;

public class UndeliveredMessageLogPersister {
    private final int periodMs;
    private final UndeliveredMessageLog undeliveredMessageLog;
    private final ScheduledExecutorService scheduledExecutorService;

    public UndeliveredMessageLogPersister(UndeliveredMessageLog undeliveredMessageLog, ConfigFactory configFactory) {
        this.undeliveredMessageLog = undeliveredMessageLog;
        this.periodMs = configFactory.getIntProperty(Configs.UNDELIVERED_MESSAGE_LOG_PERSIST_PERIOD_MS);
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("undelivered-message-log-persister-%d").build());
    }

    public void start() {
        this.scheduledExecutorService.scheduleAtFixedRate(() -> ((UndeliveredMessageLog)this.undeliveredMessageLog).persist(), this.periodMs, this.periodMs, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }
}

