/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionId;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIds;
import pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs.AssignmentsDecoder;
import pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs.MessageHeaderDecoder;

class ConsumerWorkloadDecoder {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerWorkloadDecoder.class);
    private final SubscriptionIds subscriptionIds;

    ConsumerWorkloadDecoder(SubscriptionIds subscriptionIds) {
        this.subscriptionIds = subscriptionIds;
    }

    Set<SubscriptionName> decode(byte[] data) {
        MessageHeaderDecoder header = new MessageHeaderDecoder();
        AssignmentsDecoder body = new AssignmentsDecoder();
        UnsafeBuffer buffer = new UnsafeBuffer(data);
        header.wrap((DirectBuffer)buffer, 0);
        if (header.schemaId() != 2 || header.templateId() != 1) {
            logger.warn("Unable to decode assignments, schema or template id mismatch. Required by decoder: [schema id={}, template id={}], encoded in payload: [schema id={}, template id={}]", new Object[]{2, 1, header.schemaId(), header.templateId()});
            return Collections.emptySet();
        }
        body.wrap((DirectBuffer)buffer, header.encodedLength(), header.blockLength(), header.version());
        HashSet<SubscriptionName> subscriptions = new HashSet<SubscriptionName>();
        for (AssignmentsDecoder.SubscriptionsDecoder subscriptionDecoder : body.subscriptions()) {
            long id = subscriptionDecoder.id();
            this.subscriptionIds.getSubscriptionId(id).map(SubscriptionId::getSubscriptionName).ifPresent(subscriptions::add);
        }
        return subscriptions;
    }
}

