/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.batch;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DirectBufferUtils {
    private static final Logger logger;
    private static final DirectBufferCleaner CLEANER;

    DirectBufferUtils() {
    }

    static void release(ByteBuffer buffer) {
        try {
            if (CLEANER != null && buffer.isDirect()) {
                CLEANER.clean(buffer);
            }
        }
        catch (ReflectiveOperationException e) {
            logger.warn("Releasing ByteBuffer failed", (Throwable)e);
        }
    }

    static {
        DirectBufferCleaner cleaner;
        logger = LoggerFactory.getLogger(DirectBufferUtils.class);
        try {
            cleaner = "1.8".equals(System.getProperty("java.specification.version")) ? new Java8DirectBufferCleaner() : new Java11DirectBufferCleaner();
        }
        catch (ReflectiveOperationException e) {
            cleaner = null;
        }
        CLEANER = cleaner;
    }

    static class Java11DirectBufferCleaner
    implements DirectBufferCleaner {
        private final Object unsafe;
        private final Method invokeCleaner;

        Java11DirectBufferCleaner() throws ReflectiveOperationException {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            Field field = clazz.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            this.unsafe = field.get(null);
            this.invokeCleaner = clazz.getMethod("invokeCleaner", ByteBuffer.class);
        }

        @Override
        public void clean(ByteBuffer buffer) throws ReflectiveOperationException {
            this.invokeCleaner.invoke(this.unsafe, buffer);
        }
    }

    static class Java8DirectBufferCleaner
    implements DirectBufferCleaner {
        private final Method directBufferCleaner = Class.forName("sun.nio.ch.DirectBuffer").getMethod("cleaner", new Class[0]);
        private final Method directBufferCleanerClean;

        Java8DirectBufferCleaner() throws ReflectiveOperationException {
            this.directBufferCleaner.setAccessible(true);
            this.directBufferCleanerClean = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
            this.directBufferCleanerClean.setAccessible(true);
        }

        @Override
        public void clean(ByteBuffer buffer) throws ReflectiveOperationException {
            Object cleaner = this.directBufferCleaner.invoke((Object)buffer, new Object[0]);
            this.directBufferCleanerClean.invoke(cleaner, new Object[0]);
        }
    }

    private static interface DirectBufferCleaner {
        public void clean(ByteBuffer var1) throws ReflectiveOperationException;
    }
}

