/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender;

import com.google.common.base.Preconditions;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageBatchSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageBatchSenderFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.ApacheHttpClientMessageBatchSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.SendingResultHandlers;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.DefaultBatchHeadersProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.SimpleEndpointAddressResolver;

public class HttpMessageBatchSenderFactory
implements MessageBatchSenderFactory {
    private final ConfigFactory configFactory;
    private final SendingResultHandlers resultHandlers;

    public HttpMessageBatchSenderFactory(ConfigFactory configFactory, SendingResultHandlers resultHandlers) {
        this.configFactory = configFactory;
        this.resultHandlers = resultHandlers;
    }

    @Override
    public MessageBatchSender create(Subscription subscription) {
        Preconditions.checkState((boolean)subscription.getEndpoint().getProtocol().contains("http"), (Object)"Batching is only supported for http/s currently.");
        return new ApacheHttpClientMessageBatchSender(this.configFactory.getIntProperty(Configs.CONSUMER_BATCH_CONNECTION_TIMEOUT), this.configFactory.getIntProperty(Configs.CONSUMER_BATCH_CONNECTION_REQUEST_TIMEOUT), new SimpleEndpointAddressResolver(), this.resultHandlers, new DefaultBatchHeadersProvider());
    }
}

