/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub;

import com.google.common.collect.ImmutableMap;
import com.google.pubsub.v1.PubsubMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import pl.allegro.tech.hermes.api.Header;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.trace.MetadataAppender;

public class GooglePubSubMetadataAppender
implements MetadataAppender<PubsubMessage> {
    public static final String HEADER_NAME_TOPIC_NAME = "tn";
    public static final String HEADER_NAME_MESSAGE_ID = "id";
    public static final String HEADER_NAME_SUBSCRIPTION_NAME = "sn";
    public static final String HEADER_NAME_TIMESTAMP = "ts";
    public static final String HEADER_NAME_SCHEMA_ID = "sid";
    public static final String HEADER_NAME_SCHEMA_VERSION = "sv";

    @Override
    public PubsubMessage append(PubsubMessage target, Message message) {
        Map<String, String> additionalHeaders = message.getAdditionalHeaders().stream().collect(Collectors.toMap(Header::getName, Header::getValue));
        return PubsubMessage.newBuilder((PubsubMessage)target).putAllAttributes(additionalHeaders).putAllAttributes(message.getExternalMetadata()).putAllAttributes(this.createMessageAttributes(message)).build();
    }

    private Map<String, String> createMessageAttributes(Message message) {
        Optional<Pair> schemaIdAndVersion = message.getSchema().map(s -> Pair.of((Object)String.valueOf(s.getId().value()), (Object)String.valueOf(s.getVersion().value())));
        HashMap<String, String> headers = new HashMap<String, String>((Map<String, String>)ImmutableMap.of((Object)HEADER_NAME_TOPIC_NAME, (Object)message.getTopic(), (Object)HEADER_NAME_MESSAGE_ID, (Object)message.getId(), (Object)HEADER_NAME_TIMESTAMP, (Object)String.valueOf(message.getPublishingTimestamp())));
        if (message.hasSubscriptionIdentityHeaders()) {
            headers.put(HEADER_NAME_SUBSCRIPTION_NAME, message.getSubscription());
        }
        schemaIdAndVersion.ifPresent(sv -> {
            headers.put(HEADER_NAME_SCHEMA_ID, (String)sv.getLeft());
            headers.put(HEADER_NAME_SCHEMA_VERSION, (String)sv.getRight());
        });
        return headers;
    }
}

