/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.process;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.exception.RetransmissionException;
import pl.allegro.tech.hermes.common.kafka.offset.PartitionOffset;
import pl.allegro.tech.hermes.common.kafka.offset.PartitionOffsets;
import pl.allegro.tech.hermes.common.kafka.offset.SubscriptionOffsetChangeIndicator;
import pl.allegro.tech.hermes.consumers.consumer.Consumer;

public class Retransmitter {
    private static final Logger logger = LoggerFactory.getLogger(Retransmitter.class);
    private final SubscriptionOffsetChangeIndicator subscriptionOffsetChangeIndicator;
    private final String brokersClusterName;

    public Retransmitter(SubscriptionOffsetChangeIndicator subscriptionOffsetChangeIndicator, ConfigFactory configs) {
        this.subscriptionOffsetChangeIndicator = subscriptionOffsetChangeIndicator;
        this.brokersClusterName = configs.getStringProperty(Configs.KAFKA_CLUSTER_NAME);
    }

    public void reloadOffsets(SubscriptionName subscriptionName, Consumer consumer) {
        logger.info("Reloading offsets for {}", (Object)subscriptionName);
        try {
            PartitionOffsets offsets = this.subscriptionOffsetChangeIndicator.getSubscriptionOffsets(subscriptionName.getTopicName(), subscriptionName.getName(), this.brokersClusterName);
            for (PartitionOffset partitionOffset : offsets) {
                if (!this.moveOffset(subscriptionName, consumer, partitionOffset)) continue;
                this.subscriptionOffsetChangeIndicator.removeOffset(subscriptionName.getTopicName(), subscriptionName.getName(), this.brokersClusterName, partitionOffset.getTopic(), partitionOffset.getPartition());
                logger.info("Removed offset indicator for subscription={} and partition={}", (Object)subscriptionName, (Object)partitionOffset.getPartition());
            }
        }
        catch (Exception ex) {
            throw new RetransmissionException((Throwable)ex);
        }
    }

    private boolean moveOffset(SubscriptionName subscriptionName, Consumer consumer, PartitionOffset partitionOffset) {
        try {
            return consumer.moveOffset(partitionOffset);
        }
        catch (IllegalStateException ex) {
            logger.warn("Cannot move offset for subscription={} and partition={} , possibly owned by different node", new Object[]{subscriptionName, partitionOffset.getPartition(), ex});
            return false;
        }
    }
}

