/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.calculator;

import java.util.EnumMap;
import java.util.Map;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.consumer.rate.SendCounters;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.HeartbeatModeOutputRateCalculator;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.ModeOutputRateCalculator;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.NormalModeOutputRateCalculator;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.OutputRateCalculationResult;
import pl.allegro.tech.hermes.consumers.consumer.rate.calculator.SlowModeOutputRateCalculator;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateProvider;

public class OutputRateCalculator {
    private final Map<Mode, ModeOutputRateCalculator> modeCalculators = new EnumMap<Mode, ModeOutputRateCalculator>(Mode.class);
    private final MaxRateProvider maxRateProvider;

    public OutputRateCalculator(ConfigFactory configFactory, MaxRateProvider maxRateProvider) {
        this.maxRateProvider = maxRateProvider;
        this.modeCalculators.put(Mode.NORMAL, new NormalModeOutputRateCalculator(configFactory.getDoubleProperty(Configs.CONSUMER_RATE_CONVERGENCE_FACTOR), 1.0 / (double)configFactory.getIntProperty(Configs.CONSUMER_RATE_LIMITER_SLOW_MODE_DELAY), configFactory.getDoubleProperty(Configs.CONSUMER_RATE_FAILURES_SPEEDUP_TOLERANCE_RATIO), configFactory.getDoubleProperty(Configs.CONSUMER_RATE_FAILURES_NOCHANGE_TOLERANCE_RATIO)));
        this.modeCalculators.put(Mode.SLOW, new SlowModeOutputRateCalculator(1.0 / (double)configFactory.getIntProperty(Configs.CONSUMER_RATE_LIMITER_HEARTBEAT_MODE_DELAY)));
        this.modeCalculators.put(Mode.HEARTBEAT, new HeartbeatModeOutputRateCalculator(1.0 / (double)configFactory.getIntProperty(Configs.CONSUMER_RATE_LIMITER_SLOW_MODE_DELAY)));
    }

    public OutputRateCalculationResult recalculateRate(SendCounters counters, Mode currentMode, double currentRateLimit) {
        double maximumRate = this.maxRateProvider.get();
        OutputRateCalculationResult recalculatedResult = this.modeCalculators.get((Object)currentMode).calculateOutputRate(currentRateLimit, maximumRate, counters);
        if (recalculatedResult.rate() > maximumRate) {
            recalculatedResult = OutputRateCalculationResult.adjustRate(recalculatedResult, maximumRate);
        }
        return recalculatedResult;
    }

    public void updateSubscription(Subscription newSubscription) {
        this.maxRateProvider.updateSubscription(newSubscription);
    }

    public void start() {
        this.maxRateProvider.start();
    }

    public void shutdown() {
        this.maxRateProvider.shutdown();
    }

    public static enum Mode {
        NORMAL,
        SLOW,
        HEARTBEAT;

    }
}

