/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.HttpHeadersProvider;
import pl.allegro.tech.hermes.consumers.consumer.trace.MetadataAppender;

class HttpRequestFactory {
    private final HttpClient client;
    private final long timeout;
    private final long socketTimeout;
    private final MetadataAppender<Request> metadataAppender;
    private final HttpHeadersProvider requestHeadersProvider;

    HttpRequestFactory(HttpClient client, long timeout, long socketTimeout, MetadataAppender<Request> metadataAppender, HttpHeadersProvider requestHeadersProvider) {
        this.client = client;
        this.timeout = timeout;
        this.socketTimeout = socketTimeout;
        this.metadataAppender = metadataAppender;
        this.requestHeadersProvider = requestHeadersProvider;
    }

    Request buildRequest(Message message, URI uri) {
        return new HttpRequestBuilder(message, uri).build();
    }

    private class HttpRequestBuilder {
        private final Message message;
        private final URI uri;

        HttpRequestBuilder(Message message, URI uri) {
            this.message = message;
            this.uri = uri;
        }

        Request build() {
            Request request = this.baseRequest();
            HttpRequestFactory.this.requestHeadersProvider.getHeaders(this.message).asMap().forEach((arg_0, arg_1) -> ((Request)request).header(arg_0, arg_1));
            return request;
        }

        private Request baseRequest() {
            Request baseRequest = HttpRequestFactory.this.client.newRequest(this.uri).method(HttpMethod.POST).timeout(HttpRequestFactory.this.timeout, TimeUnit.MILLISECONDS).idleTimeout(HttpRequestFactory.this.socketTimeout, TimeUnit.MILLISECONDS).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{this.message.getData()}));
            HttpRequestFactory.this.metadataAppender.append(baseRequest, this.message);
            return baseRequest;
        }
    }
}

