/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http.headers;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import pl.allegro.tech.hermes.common.http.MessageMetadataHeaders;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.HttpHeadersProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.HttpRequestHeaders;

public final class HermesHeadersProvider
implements HttpHeadersProvider {
    private final HttpHeadersProvider headersProvider;

    public HermesHeadersProvider(HttpHeadersProvider headersProvider) {
        this.headersProvider = headersProvider;
    }

    @Override
    public HttpRequestHeaders getHeaders(Message message) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.headersProvider != null) {
            builder.putAll(this.headersProvider.getHeaders(message).asMap());
        }
        builder.put((Object)MessageMetadataHeaders.MESSAGE_ID.getName(), (Object)message.getId());
        builder.put((Object)MessageMetadataHeaders.RETRY_COUNT.getName(), (Object)Integer.toString(message.getRetryCounter()));
        if (message.hasSubscriptionIdentityHeaders()) {
            builder.put((Object)MessageMetadataHeaders.TOPIC_NAME.getName(), (Object)message.getTopic());
            builder.put((Object)MessageMetadataHeaders.SUBSCRIPTION_NAME.getName(), (Object)message.getSubscription());
        }
        message.getSchema().ifPresent(schema -> builder.put((Object)MessageMetadataHeaders.SCHEMA_VERSION.getName(), (Object)String.valueOf(schema.getVersion().value())));
        message.getAdditionalHeaders().forEach(header -> builder.put((Object)header.getName(), (Object)header.getValue()));
        return new HttpRequestHeaders((Map<String, String>)builder.build());
    }
}

