/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.subscription.id;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionId;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIdProvider;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIds;
import pl.allegro.tech.hermes.domain.notifications.InternalNotificationsBus;
import pl.allegro.tech.hermes.domain.notifications.SubscriptionCallback;

public class NotificationAwareSubscriptionIdsCache
implements SubscriptionIds,
SubscriptionCallback {
    private final SubscriptionsCache subscriptionsCache;
    private final SubscriptionIdProvider subscriptionIdProvider;
    private final Map<SubscriptionName, SubscriptionId> nameToIdMap = new ConcurrentHashMap<SubscriptionName, SubscriptionId>();
    private final Map<Long, SubscriptionId> valueToIdMap = new ConcurrentHashMap<Long, SubscriptionId>();

    public NotificationAwareSubscriptionIdsCache(InternalNotificationsBus notificationsBus, SubscriptionsCache subscriptionsCache, SubscriptionIdProvider subscriptionIdProvider) {
        this.subscriptionsCache = subscriptionsCache;
        this.subscriptionIdProvider = subscriptionIdProvider;
        notificationsBus.registerSubscriptionCallback((SubscriptionCallback)this);
    }

    @Override
    public void start() {
        this.subscriptionsCache.listActiveSubscriptionNames().forEach(this::putSubscriptionId);
    }

    private void putSubscriptionId(SubscriptionName name) {
        SubscriptionId id = this.subscriptionIdProvider.getSubscriptionId(name);
        this.nameToIdMap.put(name, id);
        this.valueToIdMap.put(id.getValue(), id);
    }

    @Override
    public Optional<SubscriptionId> getSubscriptionId(SubscriptionName subscriptionName) {
        return Optional.ofNullable(this.nameToIdMap.get(subscriptionName));
    }

    @Override
    public Optional<SubscriptionId> getSubscriptionId(long id) {
        return Optional.ofNullable(this.valueToIdMap.get(id));
    }

    public void onSubscriptionCreated(Subscription subscription) {
        this.putSubscriptionId(subscription.getQualifiedName());
    }

    public void onSubscriptionChanged(Subscription subscription) {
        this.putSubscriptionId(subscription.getQualifiedName());
    }

    public void onSubscriptionRemoved(Subscription subscription) {
        Optional.ofNullable(this.nameToIdMap.remove(subscription.getQualifiedName())).map(SubscriptionId::getValue).ifPresent(this.valueToIdMap::remove);
    }
}

