/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import javax.inject.Inject;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.CreateMode;
import org.glassfish.hk2.api.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIds;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ConsumerAssignmentCache;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ConsumerAssignmentRegistry;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ConsumerWorkloadRegistryType;
import pl.allegro.tech.hermes.consumers.supervisor.workload.FlatBinaryConsumerAssignmentRegistry;
import pl.allegro.tech.hermes.consumers.supervisor.workload.HierarchicalConsumerAssignmentRegistry;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentPathSerializer;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;

public class ConsumerAssignmentRegistryFactory
implements Factory<ConsumerAssignmentRegistry> {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerAssignmentRegistryFactory.class);
    private final CuratorFramework curator;
    private final ConfigFactory configFactory;
    private final ZookeeperPaths zookeeperPaths;
    private final ConsumerAssignmentCache consumerAssignmentCache;
    private final SubscriptionIds subscriptionIds;

    @Inject
    public ConsumerAssignmentRegistryFactory(CuratorFramework curator, ConfigFactory configFactory, ZookeeperPaths zookeeperPaths, ConsumerAssignmentCache consumerAssignmentCache, SubscriptionIds subscriptionIds) {
        this.curator = curator;
        this.configFactory = configFactory;
        this.zookeeperPaths = zookeeperPaths;
        this.consumerAssignmentCache = consumerAssignmentCache;
        this.subscriptionIds = subscriptionIds;
    }

    public ConsumerAssignmentRegistry provide() {
        ConsumerWorkloadRegistryType type;
        try {
            String typeString = this.configFactory.getStringProperty(Configs.CONSUMER_WORKLOAD_REGISTRY_TYPE);
            type = ConsumerWorkloadRegistryType.fromString(typeString);
        }
        catch (Exception e) {
            logger.error("Could not configure consumer workload registry", (Throwable)e);
            throw e;
        }
        logger.info("Consumer workload registry type chosen: {}", (Object)type.getConfigValue());
        switch (type) {
            case HIERARCHICAL: {
                String cluster = this.configFactory.getStringProperty(Configs.KAFKA_CLUSTER_NAME);
                String consumersRuntimePath = this.zookeeperPaths.consumersRuntimePath(cluster);
                SubscriptionAssignmentPathSerializer pathSerializer = new SubscriptionAssignmentPathSerializer(consumersRuntimePath, HierarchicalConsumerAssignmentRegistry.AUTO_ASSIGNED_MARKER);
                CreateMode assignmentNodeCreationMode = this.getAssignmentNodeCreationMode();
                return new HierarchicalConsumerAssignmentRegistry(this.curator, this.consumerAssignmentCache, pathSerializer, assignmentNodeCreationMode);
            }
            case FLAT_BINARY: {
                return new FlatBinaryConsumerAssignmentRegistry(this.curator, this.configFactory, this.zookeeperPaths, this.subscriptionIds);
            }
        }
        throw new UnsupportedOperationException("Max-rate type not supported.");
    }

    private CreateMode getAssignmentNodeCreationMode() {
        String algorithm = this.configFactory.getStringProperty(Configs.CONSUMER_WORKLOAD_ALGORITHM);
        return "selective".equals(algorithm) ? CreateMode.PERSISTENT : CreateMode.EPHEMERAL;
    }

    public void dispose(ConsumerAssignmentRegistry instance) {
    }
}

