/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.util.Collection;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.Http2ClientHolder;

public class HttpClientsWorkloadReporter {
    private final HermesMetrics metrics;
    private final HttpClient httpClient;
    private final Http2ClientHolder http2ClientHolder;
    private final Function<HttpClient, Integer> getQueueSize = httpClient -> httpClient.getDestinations().stream().map(HttpDestination.class::cast).map(HttpDestination::getHttpExchanges).map(Collection::size).mapToInt(i -> i).sum();

    @Inject
    public HttpClientsWorkloadReporter(HermesMetrics metrics, @Named(value="http-1-client") HttpClient httpClient2, Http2ClientHolder http2ClientHolder) {
        this.metrics = metrics;
        this.httpClient = httpClient2;
        this.http2ClientHolder = http2ClientHolder;
    }

    public void start() {
        this.metrics.registerConsumerSenderRequestQueueSize(this::getQueuesSize);
        this.metrics.registerConsumerSenderHttp1RequestQueueSize(this::getHttp1QueueSize);
        this.metrics.registerConsumerSenderHttp2RequestQueueSize(this::getHttp2QueueSize);
    }

    int getQueuesSize() {
        return this.getHttp1QueueSize() + this.getHttp2QueueSize();
    }

    int getHttp1QueueSize() {
        return this.getQueueSize.apply(this.httpClient);
    }

    int getHttp2QueueSize() {
        return this.http2ClientHolder.getHttp2Client().map(this.getQueueSize).orElse(0);
    }
}

