/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.filtering;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import pl.allegro.tech.hermes.api.MessageFilterSpecification;
import pl.allegro.tech.hermes.consumers.consumer.filtering.MessageFilter;
import pl.allegro.tech.hermes.consumers.consumer.filtering.MessageFilterSource;
import pl.allegro.tech.hermes.consumers.consumer.filtering.NoSuchFilterException;
import pl.allegro.tech.hermes.consumers.consumer.filtering.SubscriptionMessageFilterCompiler;

public class MessageFilters
implements MessageFilterSource {
    private Map<String, SubscriptionMessageFilterCompiler> filters;
    private List<MessageFilter> globalFilters;

    public MessageFilters(List<MessageFilter> globalFilters, List<SubscriptionMessageFilterCompiler> subscriptionFilterCompilers) {
        this.globalFilters = globalFilters;
        this.filters = subscriptionFilterCompilers.stream().collect(Collectors.toMap(SubscriptionMessageFilterCompiler::getType, Function.identity()));
    }

    @Override
    public MessageFilter compile(MessageFilterSpecification specification) {
        if (!this.filters.containsKey(specification.getType())) {
            throw new NoSuchFilterException(specification.getType());
        }
        return this.filters.get(specification.getType()).getMessageFilter(specification);
    }

    @Override
    public List<MessageFilter> getGlobalFilters() {
        return this.globalFilters;
    }
}

