/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.oauth;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import pl.allegro.tech.hermes.api.OAuthProvider;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.consumer.oauth.OAuthTokenRequestRateLimiter;
import pl.allegro.tech.hermes.domain.oauth.OAuthProviderRepository;

public class OAuthTokenRequestRateLimiterFactory {
    private final OAuthProviderRepository oAuthProviderRepository;
    private final double rateReductionFactor;

    @Inject
    public OAuthTokenRequestRateLimiterFactory(OAuthProviderRepository oAuthProviderRepository, ConfigFactory configFactory) {
        this.oAuthProviderRepository = oAuthProviderRepository;
        this.rateReductionFactor = configFactory.getDoubleProperty(Configs.OAUTH_PROVIDERS_TOKEN_REQUEST_RATE_LIMITER_RATE_REDUCTION_FACTOR);
        Preconditions.checkArgument((this.rateReductionFactor >= 1.0 ? 1 : 0) != 0, (Object)"Token request rate limiter rate reduction factor must be greater or equal to 1");
    }

    public OAuthTokenRequestRateLimiter create(Subscription subscription) {
        String providerName = subscription.getOAuthPolicy().getProviderName();
        OAuthProvider oAuthProvider = this.oAuthProviderRepository.getOAuthProviderDetails(providerName);
        double initialRate = this.delayToRate(oAuthProvider.getTokenRequestInitialDelay());
        double minimalRate = this.delayToRate(oAuthProvider.getTokenRequestMaxDelay());
        return new OAuthTokenRequestRateLimiter(initialRate, minimalRate, this.rateReductionFactor, oAuthProvider.getTokenRequestInitialDelay().intValue());
    }

    private double delayToRate(Integer delay) {
        return 1000.0 / (double)delay.intValue();
    }
}

