/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.ssl.DefaultSslContextFactory;
import pl.allegro.tech.hermes.common.ssl.KeyManagersProvider;
import pl.allegro.tech.hermes.common.ssl.KeystoreConfigurationException;
import pl.allegro.tech.hermes.common.ssl.KeystoreProperties;
import pl.allegro.tech.hermes.common.ssl.KeystoreSource;
import pl.allegro.tech.hermes.common.ssl.TrustManagersProvider;
import pl.allegro.tech.hermes.common.ssl.TruststoreConfigurationException;
import pl.allegro.tech.hermes.common.ssl.jvm.JvmKeyManagersProvider;
import pl.allegro.tech.hermes.common.ssl.jvm.JvmTrustManagerProvider;
import pl.allegro.tech.hermes.common.ssl.provided.ProvidedKeyManagersProvider;
import pl.allegro.tech.hermes.common.ssl.provided.ProvidedTrustManagersProvider;

public class SslContextFactoryProvider {
    @Inject
    @org.jvnet.hk2.annotations.Optional
    pl.allegro.tech.hermes.common.ssl.SslContextFactory sslContextFactory;
    @Inject
    ConfigFactory configFactory;

    public Optional<SslContextFactory> provideSslContextFactory() {
        if (this.configFactory.getBooleanProperty(Configs.CONSUMER_SSL_ENABLED)) {
            SslContextFactory sslCtx = new SslContextFactory();
            sslCtx.setEndpointIdentificationAlgorithm("HTTPS");
            sslCtx.setSslContext(this.sslContextFactory().create().getSslContext());
            return Optional.of(sslCtx);
        }
        return Optional.empty();
    }

    private pl.allegro.tech.hermes.common.ssl.SslContextFactory sslContextFactory() {
        return Optional.ofNullable(this.sslContextFactory).orElseGet(this::defaultSslContextFactory);
    }

    private pl.allegro.tech.hermes.common.ssl.SslContextFactory defaultSslContextFactory() {
        String protocol = this.configFactory.getStringProperty(Configs.CONSUMER_SSL_PROTOCOL);
        KeyManagersProvider keyManagersProvider = this.createKeyManagersProvider();
        TrustManagersProvider trustManagersProvider = this.createTrustManagersProvider();
        return new DefaultSslContextFactory(protocol, keyManagersProvider, trustManagersProvider);
    }

    private KeyManagersProvider createKeyManagersProvider() {
        String keystoreSource = this.configFactory.getStringProperty(Configs.CONSUMER_SSL_KEYSTORE_SOURCE);
        if (KeystoreSource.PROVIDED.getValue().equals(keystoreSource)) {
            KeystoreProperties properties = new KeystoreProperties(this.configFactory.getStringProperty(Configs.CONSUMER_SSL_KEYSTORE_LOCATION), this.configFactory.getStringProperty(Configs.CONSUMER_SSL_KEYSTORE_FORMAT), this.configFactory.getStringProperty(Configs.CONSUMER_SSL_KEYSTORE_PASSWORD));
            return new ProvidedKeyManagersProvider(properties);
        }
        if (KeystoreSource.JRE.getValue().equals(keystoreSource)) {
            return new JvmKeyManagersProvider();
        }
        throw new KeystoreConfigurationException(keystoreSource);
    }

    public TrustManagersProvider createTrustManagersProvider() {
        String truststoreSource = this.configFactory.getStringProperty(Configs.CONSUMER_SSL_TRUSTSTORE_SOURCE);
        if (KeystoreSource.PROVIDED.getValue().equals(truststoreSource)) {
            KeystoreProperties properties = new KeystoreProperties(this.configFactory.getStringProperty(Configs.CONSUMER_SSL_TRUSTSTORE_LOCATION), this.configFactory.getStringProperty(Configs.CONSUMER_SSL_TRUSTSTORE_FORMAT), this.configFactory.getStringProperty(Configs.CONSUMER_SSL_TRUSTSTORE_PASSWORD));
            return new ProvidedTrustManagersProvider(properties);
        }
        if (KeystoreSource.JRE.getValue().equals(truststoreSource)) {
            return new JvmTrustManagerProvider();
        }
        throw new TruststoreConfigurationException(truststoreSource);
    }
}

