/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.filtering.chain;

import java.util.ArrayList;
import java.util.List;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.filtering.MessageFilter;
import pl.allegro.tech.hermes.consumers.consumer.filtering.chain.FilterResult;

public final class FilterChain {
    private final List<MessageFilter> messageFilters;

    public FilterChain(List<MessageFilter> messageFilters) {
        this.messageFilters = new ArrayList<MessageFilter>(messageFilters);
    }

    public FilterResult apply(Message message) {
        for (MessageFilter filter : this.messageFilters) {
            try {
                if (filter.test(message)) continue;
                return FilterResult.failed(filter.getType(), "logical");
            }
            catch (Exception ex) {
                return FilterResult.failed(filter.getType(), ex);
            }
        }
        return FilterResult.PASS;
    }
}

