/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import pl.allegro.tech.hermes.api.EndpointAddress;
import pl.allegro.tech.hermes.api.EndpointAddressResolverMetadata;
import pl.allegro.tech.hermes.common.http.MessageMetadataHeaders;
import pl.allegro.tech.hermes.consumers.consumer.batch.MessageBatch;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageBatchSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.SingleMessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.ByteBufferEntity;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolutionException;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolver;

public class ApacheHttpClientMessageBatchSender
implements MessageBatchSender {
    private final int connectionTimeout;
    private final int connectionRequestTimeout;
    private final EndpointAddressResolver resolver;
    private CloseableHttpClient client = HttpClients.createMinimal();

    public ApacheHttpClientMessageBatchSender(int connectionTimeout, int connectionRequestTimeout, EndpointAddressResolver resolver) {
        this.connectionTimeout = connectionTimeout;
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.resolver = resolver;
    }

    @Override
    public MessageSendingResult send(MessageBatch batch, EndpointAddress address, EndpointAddressResolverMetadata metadata, int requestTimeout) {
        try {
            return this.send(batch, this.resolver.resolve(address, batch, metadata), requestTimeout);
        }
        catch (EndpointAddressResolutionException e) {
            return MessageSendingResult.failedResult(e);
        }
    }

    public MessageSendingResult send(MessageBatch batch, URI address, int requestTimeout) {
        ContentType contentType = this.getMediaType(batch.getContentType());
        HttpPost httpPost = new HttpPost(address);
        ByteBufferEntity entity = new ByteBufferEntity(batch.getContent(), contentType);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectionTimeout).setConnectionRequestTimeout(this.connectionRequestTimeout).setSocketTimeout(requestTimeout).build();
        httpPost.setConfig(requestConfig);
        httpPost.setEntity((HttpEntity)entity);
        httpPost.addHeader("Keep-Alive", "true");
        httpPost.addHeader(MessageMetadataHeaders.BATCH_ID.getName(), batch.getId());
        httpPost.addHeader("Content-Type", contentType.getMimeType());
        httpPost.addHeader(MessageMetadataHeaders.RETRY_COUNT.getName(), Integer.toString(batch.getRetryCounter()));
        if (batch.hasSubscriptionIdentityHeaders()) {
            httpPost.addHeader(MessageMetadataHeaders.TOPIC_NAME.getName(), batch.getTopic());
            httpPost.addHeader(MessageMetadataHeaders.SUBSCRIPTION_NAME.getName(), batch.getSubscription().getName());
        }
        batch.getAdditionalHeaders().forEach(header -> httpPost.addHeader(header.getName(), header.getValue()));
        return this.send(httpPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageSendingResult send(HttpPost post) {
        try {
            SingleMessageSendingResult singleMessageSendingResult = MessageSendingResult.ofStatusCode(this.client.execute((HttpUriRequest)post).getStatusLine().getStatusCode());
            return singleMessageSendingResult;
        }
        catch (IOException e) {
            SingleMessageSendingResult singleMessageSendingResult = MessageSendingResult.failedResult(e);
            return singleMessageSendingResult;
        }
        finally {
            post.releaseConnection();
        }
    }

    public ContentType getMediaType(pl.allegro.tech.hermes.api.ContentType contentType) {
        return pl.allegro.tech.hermes.api.ContentType.AVRO.equals((Object)contentType) ? ContentType.create((String)"avro/binary") : ContentType.APPLICATION_JSON;
    }
}

