/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.net.CookieStore;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.metric.executor.InstrumentedExecutorServiceFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.SslContextFactoryProvider;

public class HttpClientsFactory {
    private final ConfigFactory configFactory;
    private final InstrumentedExecutorServiceFactory executorFactory;
    private final pl.allegro.tech.hermes.common.ssl.SslContextFactory sslContextFactory;

    @Inject
    public HttpClientsFactory(ConfigFactory configFactory, InstrumentedExecutorServiceFactory executorFactory, SslContextFactoryProvider sslContextFactoryProvider) {
        this.configFactory = configFactory;
        this.executorFactory = executorFactory;
        this.sslContextFactory = sslContextFactoryProvider.getSslContextFactory();
    }

    public HttpClient createClientForHttp1(String name) {
        ExecutorService executor = this.executorFactory.getExecutorService(name, this.configFactory.getIntProperty(Configs.CONSUMER_HTTP_CLIENT_THREAD_POOL_SIZE), this.configFactory.getBooleanProperty(Configs.CONSUMER_HTTP_CLIENT_THREAD_POOL_MONITORING));
        HttpClient client = new HttpClient(this.createSslContextFactory());
        client.setMaxConnectionsPerDestination(this.configFactory.getIntProperty(Configs.CONSUMER_HTTP_CLIENT_MAX_CONNECTIONS_PER_DESTINATION));
        client.setMaxRequestsQueuedPerDestination(this.configFactory.getIntProperty(Configs.CONSUMER_HTTP_CLIENT_MAX_REQUESTS_QUEUED_PER_DESTINATION));
        client.setExecutor((Executor)executor);
        client.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        client.setIdleTimeout((long)this.configFactory.getIntProperty(Configs.CONSUMER_HTTP_CLIENT_IDLE_TIMEOUT));
        client.setFollowRedirects(this.configFactory.getBooleanProperty(Configs.CONSUMER_HTTP_CLIENT_FOLLOW_REDIRECTS));
        return client;
    }

    public HttpClient createClientForHttp2() {
        ExecutorService executor = this.executorFactory.getExecutorService("jetty-http2-client", this.configFactory.getIntProperty(Configs.CONSUMER_HTTP2_CLIENT_THREAD_POOL_SIZE), this.configFactory.getBooleanProperty(Configs.CONSUMER_HTTP2_CLIENT_THREAD_POOL_MONITORING));
        HTTP2Client http2Client = new HTTP2Client();
        http2Client.setExecutor((Executor)executor);
        HttpClientTransportOverHTTP2 transport = new HttpClientTransportOverHTTP2(http2Client);
        HttpClient client = new HttpClient((HttpClientTransport)transport, this.createSslContextFactory());
        client.setMaxRequestsQueuedPerDestination(this.configFactory.getIntProperty(Configs.CONSUMER_HTTP2_CLIENT_MAX_REQUESTS_QUEUED_PER_DESTINATION));
        client.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        client.setIdleTimeout((long)this.configFactory.getIntProperty(Configs.CONSUMER_HTTP2_CLIENT_IDLE_TIMEOUT));
        client.setFollowRedirects(this.configFactory.getBooleanProperty(Configs.CONSUMER_HTTP_CLIENT_FOLLOW_REDIRECTS));
        return client;
    }

    private SslContextFactory createSslContextFactory() {
        SslContextFactory sslCtx = new SslContextFactory();
        sslCtx.setEndpointIdentificationAlgorithm("HTTPS");
        sslCtx.setSslContext(this.sslContextFactory.create().getSslContext());
        return sslCtx;
    }
}

