/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.receiver.kafka;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.common.message.wrapper.MessageContentWrapper;
import pl.allegro.tech.hermes.common.message.wrapper.UnsupportedContentTypeException;
import pl.allegro.tech.hermes.common.message.wrapper.UnwrappedMessageContent;
import pl.allegro.tech.hermes.consumers.consumer.receiver.kafka.KafkaHeaderExtractor;
import pl.allegro.tech.hermes.consumers.consumer.receiver.kafka.MessageContentReader;

class BasicMessageContentReader
implements MessageContentReader {
    private final MessageContentWrapper messageContentWrapper;
    private final KafkaHeaderExtractor kafkaHeaderExtractor;
    private final Topic topic;

    BasicMessageContentReader(MessageContentWrapper messageContentWrapper, KafkaHeaderExtractor kafkaHeaderExtractor, Topic topic) {
        this.messageContentWrapper = messageContentWrapper;
        this.kafkaHeaderExtractor = kafkaHeaderExtractor;
        this.topic = topic;
    }

    @Override
    public UnwrappedMessageContent read(ConsumerRecord<byte[], byte[]> message, ContentType contentType) {
        if (contentType == ContentType.AVRO) {
            Integer schemaVersion = this.kafkaHeaderExtractor.extractSchemaVersion(message.headers());
            return this.messageContentWrapper.unwrapAvro((byte[])message.value(), this.topic, schemaVersion);
        }
        if (contentType == ContentType.JSON) {
            return this.messageContentWrapper.unwrapJson((byte[])message.value());
        }
        throw new UnsupportedContentTypeException(this.topic);
    }
}

