/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender;

import java.util.HashMap;
import java.util.Map;
import pl.allegro.tech.hermes.api.EndpointAddress;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.exception.EndpointProtocolNotSupportedException;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.ProtocolMessageSenderProvider;

public class MessageSenderFactory {
    private final Map<String, ProtocolMessageSenderProvider> protocolProviders = new HashMap<String, ProtocolMessageSenderProvider>();

    public MessageSender create(Subscription subscription) {
        EndpointAddress endpoint = subscription.getEndpoint();
        ProtocolMessageSenderProvider provider = this.protocolProviders.get(endpoint.getProtocol());
        if (provider == null) {
            throw new EndpointProtocolNotSupportedException(endpoint);
        }
        return provider.create(subscription);
    }

    public void addSupportedProtocol(String protocol, ProtocolMessageSenderProvider provider) {
        if (!this.protocolProviders.containsKey(protocol)) {
            this.overrideProtocol(protocol, provider);
        }
    }

    public void overrideProtocol(String protocol, ProtocolMessageSenderProvider provider) {
        this.startProvider(provider);
        this.protocolProviders.put(protocol, provider);
    }

    public void startProvider(ProtocolMessageSenderProvider provider) {
        try {
            provider.start();
        }
        catch (Exception e) {
            throw new InternalProcessingException("Something went wrong while starting message sender provider", (Throwable)e);
        }
    }

    public void closeProviders() {
        this.protocolProviders.values().forEach(provider -> {
            try {
                provider.stop();
            }
            catch (Exception e) {
                throw new InternalProcessingException("Something went wrong while stopping message sender provider", (Throwable)e);
            }
        });
    }
}

