/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.jetty.client.AbstractConnectionPool;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.MultiplexConnectionPool;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.Http2ClientHolder;

public class HttpClientsWorkloadReporter {
    private final HermesMetrics metrics;
    private final HttpClient httpClient;
    private final Http2ClientHolder http2ClientHolder;
    private final boolean isConnectionPoolMonitoringEnabled;
    private final boolean isRequestQueueMonitoringEnabled;
    private final Function<HttpClient, Integer> getQueueSize = httpClient -> httpClient.getDestinations().stream().map(HttpDestination.class::cast).map(HttpDestination::getHttpExchanges).map(Collection::size).mapToInt(i -> i).sum();
    private final Function<HttpClient, Integer> getHttp1ActiveConnectionsCount = httpClient -> this.getHttp1ConnectionPool((HttpClient)httpClient).map(DuplexConnectionPool::getActiveConnectionCount).mapToInt(i -> i).sum();
    private final Function<HttpClient, Integer> getHttp1IdleConnectionsCount = httpClient -> this.getHttp1ConnectionPool((HttpClient)httpClient).map(DuplexConnectionPool::getIdleConnectionCount).mapToInt(i -> i).sum();
    private final Function<HttpClient, Integer> getHttp2ConnectionsCount = http2Client -> this.getHttp2ConnectionPool((HttpClient)http2Client).map(AbstractConnectionPool::getConnectionCount).mapToInt(i -> i).sum();
    private final Function<HttpClient, Integer> getHttp2PendingConnectionsCount = http2Client -> this.getHttp2ConnectionPool((HttpClient)http2Client).map(AbstractConnectionPool::getPendingCount).mapToInt(i -> i).sum();

    @Inject
    public HttpClientsWorkloadReporter(HermesMetrics metrics, @Named(value="http-1-client") HttpClient httpClient2, Http2ClientHolder http2ClientHolder, ConfigFactory configFactory) {
        this.metrics = metrics;
        this.httpClient = httpClient2;
        this.http2ClientHolder = http2ClientHolder;
        this.isRequestQueueMonitoringEnabled = configFactory.getBooleanProperty(Configs.CONSUMER_HTTP_CLIENT_REQUEST_QUEUE_MONITORING_ENABLED);
        this.isConnectionPoolMonitoringEnabled = configFactory.getBooleanProperty(Configs.CONSUMER_HTTP_CLIENT_CONNECTION_POOL_MONITORING_ENABLED);
    }

    public void start() {
        if (this.isRequestQueueMonitoringEnabled) {
            this.registerRequestQueueSizeGauges();
        }
        if (this.isConnectionPoolMonitoringEnabled) {
            this.registerConnectionGauges();
        }
    }

    private void registerRequestQueueSizeGauges() {
        this.metrics.registerConsumerSenderRequestQueueSize(this::getQueuesSize);
        this.metrics.registerConsumerSenderHttp1RequestQueueSize(this::getHttp1QueueSize);
        this.metrics.registerConsumerSenderHttp2RequestQueueSize(this::getHttp2QueueSize);
    }

    private void registerConnectionGauges() {
        this.metrics.registerGauge("http-clients.http1.active-connections", () -> this.getHttp1ActiveConnectionsCount.apply(this.httpClient));
        this.metrics.registerGauge("http-clients.http1.idle-connections", () -> this.getHttp1IdleConnectionsCount.apply(this.httpClient));
        this.metrics.registerGauge("http-clients.http2.connections", () -> this.http2ClientHolder.getHttp2Client().map(this.getHttp2ConnectionsCount).orElse(0));
        this.metrics.registerGauge("http-clients.http2.pending-connections", () -> this.http2ClientHolder.getHttp2Client().map(this.getHttp2PendingConnectionsCount).orElse(0));
    }

    int getQueuesSize() {
        return this.getHttp1QueueSize() + this.getHttp2QueueSize();
    }

    int getHttp1QueueSize() {
        return this.getQueueSize.apply(this.httpClient);
    }

    int getHttp2QueueSize() {
        return this.http2ClientHolder.getHttp2Client().map(this.getQueueSize).orElse(0);
    }

    private Stream<ConnectionPool> getConnectionPool(HttpClient httpClient) {
        return httpClient.getDestinations().stream().map(HttpDestination.class::cast).map(HttpDestination::getConnectionPool);
    }

    private Stream<DuplexConnectionPool> getHttp1ConnectionPool(HttpClient httpClient) {
        return this.getConnectionPool(httpClient).map(DuplexConnectionPool.class::cast);
    }

    private Stream<MultiplexConnectionPool> getHttp2ConnectionPool(HttpClient http2Client) {
        return this.getConnectionPool(http2Client).map(MultiplexConnectionPool.class::cast);
    }
}

