/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.resolver;

import java.net.URI;
import java.util.List;
import pl.allegro.tech.hermes.api.EndpointAddress;
import pl.allegro.tech.hermes.api.EndpointAddressResolverMetadata;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolutionException;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolver;

public class ResolvableEndpointAddress {
    private final EndpointAddress address;
    private final EndpointAddressResolver resolver;
    private final EndpointAddressResolverMetadata metadata;

    public ResolvableEndpointAddress(EndpointAddress address, EndpointAddressResolver resolver, EndpointAddressResolverMetadata metadata) {
        this.address = address;
        this.resolver = resolver;
        this.metadata = metadata;
    }

    public URI resolveFor(Message message) throws EndpointAddressResolutionException {
        return this.resolver.resolve(this.address, message, this.metadata);
    }

    public List<URI> resolveAllFor(Message message) throws EndpointAddressResolutionException {
        return this.resolver.resolveAll(this.address, message, this.metadata);
    }

    public EndpointAddress getRawAddress() {
        return this.address;
    }

    public String toString() {
        return this.address.toString();
    }
}

