/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.process;

import java.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.supervisor.process.RunningConsumerProcess;
import pl.allegro.tech.hermes.consumers.supervisor.process.RunningConsumerProcesses;

class ConsumerProcessKiller {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerProcessKiller.class);
    private final long killAfterMs;
    private final Clock clock;
    private final RunningConsumerProcesses dyingConsumerProcesses;

    ConsumerProcessKiller(long killAfterMs, Clock clock) {
        this.clock = clock;
        this.killAfterMs = killAfterMs;
        this.dyingConsumerProcesses = new RunningConsumerProcesses(clock);
    }

    int countDying() {
        return this.dyingConsumerProcesses.count();
    }

    void killAllDying() {
        this.dyingConsumerProcesses.stream().filter(RunningConsumerProcess::shouldBeCanceledNow).forEach(RunningConsumerProcess::cancel);
    }

    void kill(RunningConsumerProcess process) {
        this.observe(process).cancel();
    }

    boolean isDying(SubscriptionName subscriptionName) {
        return this.dyingConsumerProcesses.hasProcess(subscriptionName);
    }

    void cleanup(SubscriptionName subscriptionName) {
        logger.info("Removing consumer process for subscription {}", (Object)subscriptionName);
        this.dyingConsumerProcesses.remove(subscriptionName);
    }

    RunningConsumerProcess observe(RunningConsumerProcess process) {
        RunningConsumerProcess observed = process.copyWithTimeOfDeath(this.clock.millis() + this.killAfterMs);
        this.dyingConsumerProcesses.add(observed);
        return observed;
    }
}

