/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.process;

import com.google.common.collect.ImmutableSet;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.supervisor.process.ConsumerProcess;
import pl.allegro.tech.hermes.consumers.supervisor.process.RunningConsumerProcess;
import pl.allegro.tech.hermes.consumers.supervisor.process.RunningSubscriptionStatus;

class RunningConsumerProcesses {
    private final Map<SubscriptionName, RunningConsumerProcess> processes = new ConcurrentHashMap<SubscriptionName, RunningConsumerProcess>();
    private final Clock clock;

    RunningConsumerProcesses(Clock clock) {
        this.clock = clock;
    }

    void add(ConsumerProcess process, Future executionHandle) {
        this.processes.put(process.getSubscription().getQualifiedName(), new RunningConsumerProcess(process, executionHandle, this.clock));
    }

    void add(RunningConsumerProcess process) {
        this.processes.put(process.getConsumerProcess().getSubscriptionName(), process);
    }

    void remove(SubscriptionName subscriptionName) {
        this.processes.remove(subscriptionName);
    }

    public void remove(ConsumerProcess consumerProcess) {
        this.remove(consumerProcess.getSubscriptionName());
    }

    void remove(RunningConsumerProcess runningProcess) {
        this.remove(runningProcess.getConsumerProcess().getSubscriptionName());
    }

    RunningConsumerProcess getProcess(SubscriptionName subscriptionName) {
        return this.processes.get(subscriptionName);
    }

    boolean hasProcess(SubscriptionName subscriptionName) {
        return this.processes.containsKey(subscriptionName);
    }

    Stream<RunningConsumerProcess> stream() {
        return this.processes.values().stream();
    }

    Set<SubscriptionName> existingConsumers() {
        return ImmutableSet.copyOf(this.processes.keySet());
    }

    List<RunningSubscriptionStatus> listRunningSubscriptions() {
        return this.processes.entrySet().stream().map(entry -> new RunningSubscriptionStatus(((SubscriptionName)entry.getKey()).getQualifiedName(), ((RunningConsumerProcess)entry.getValue()).getConsumerProcess().getSignalTimesheet())).sorted((s1, s2) -> String.CASE_INSENSITIVE_ORDER.compare(s1.getQualifiedName(), s2.getQualifiedName())).collect(Collectors.toList());
    }

    Integer count() {
        return this.processes.size();
    }
}

