/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.registry.ConsumerNodesRegistry;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIds;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ClusterAssignmentCache;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ConsumerWorkloadDecoder;
import pl.allegro.tech.hermes.consumers.supervisor.workload.FlatBinaryWorkloadRegistryPaths;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignment;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentView;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ZookeeperOperations;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;

public class FlatBinaryClusterAssignmentCache
implements ClusterAssignmentCache {
    private static final Logger logger = LoggerFactory.getLogger(FlatBinaryClusterAssignmentCache.class);
    private final ConsumerNodesRegistry consumerNodesRegistry;
    private final FlatBinaryWorkloadRegistryPaths paths;
    private final ConsumerWorkloadDecoder consumerWorkloadDecoder;
    private final String consumersPath;
    private final ZookeeperOperations zookeeper;
    private final Map<String, Set<SubscriptionName>> consumerSubscriptions = new ConcurrentHashMap<String, Set<SubscriptionName>>();
    private final Set<SubscriptionAssignment> assignments = Collections.newSetFromMap(new ConcurrentHashMap());

    public FlatBinaryClusterAssignmentCache(CuratorFramework curator, String clusterName, ZookeeperPaths zookeeperPaths, SubscriptionIds subscriptionIds, ConsumerNodesRegistry consumerNodesRegistry) {
        this.zookeeper = new ZookeeperOperations(curator);
        this.consumerNodesRegistry = consumerNodesRegistry;
        this.paths = new FlatBinaryWorkloadRegistryPaths(zookeeperPaths, clusterName);
        this.consumerWorkloadDecoder = new ConsumerWorkloadDecoder(subscriptionIds);
        this.consumersPath = this.paths.consumersWorkloadCurrentClusterRuntimeBinaryPath();
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void refresh() {
        logger.info("Refreshing consumer workload assignments");
        List<String> currentlyAssignedConsumers = this.getWorkloadConsumers();
        List<String> activeConsumers = this.consumerNodesRegistry.listConsumerNodes();
        this.assignments.clear();
        this.consumerSubscriptions.clear();
        for (String consumer : currentlyAssignedConsumers) {
            if (activeConsumers.contains(consumer)) {
                Set<SubscriptionName> subscriptions = this.readConsumerWorkload(consumer);
                this.consumerSubscriptions.put(consumer, subscriptions);
                subscriptions.forEach(subscription -> this.assignments.add(new SubscriptionAssignment(consumer, (SubscriptionName)subscription)));
                continue;
            }
            logger.info("Deleting consumer {} from workload", (Object)consumer);
            this.deleteConsumerWorkloadNode(consumer);
        }
    }

    private Set<SubscriptionName> readConsumerWorkload(String consumer) {
        Optional<byte[]> nodeData = this.zookeeper.getNodeData(this.paths.consumerWorkloadPath(consumer));
        if (nodeData.isPresent()) {
            byte[] data = nodeData.get();
            Set<SubscriptionName> subscriptions = this.consumerWorkloadDecoder.decode(data);
            logger.info("Decoded {} bytes of assignments for consumer {} with {} subscription entries", new Object[]{data.length, consumer, subscriptions.size()});
            return subscriptions;
        }
        logger.info("No workload data available for consumer {}", (Object)consumer);
        return Collections.emptySet();
    }

    private void deleteConsumerWorkloadNode(String consumer) {
        String path = this.paths.consumerWorkloadPath(consumer);
        try {
            this.zookeeper.deleteNode(path);
        }
        catch (Exception e) {
            logger.warn("Could not delete consumer workload node at {}", (Object)path, (Object)e);
        }
    }

    private List<String> getWorkloadConsumers() {
        try {
            if (this.zookeeper.exists(this.consumersPath)) {
                return this.zookeeper.getNodeChildren(this.consumersPath);
            }
        }
        catch (Exception e) {
            logger.warn("Could not get workload consumer nodes list", (Throwable)e);
        }
        return Collections.emptyList();
    }

    @Override
    public SubscriptionAssignmentView createSnapshot() {
        return SubscriptionAssignmentView.of(this.assignments);
    }

    @Override
    public boolean isAssignedTo(String consumerId, SubscriptionName subscription) {
        Set subscriptions = this.consumerSubscriptions.getOrDefault(consumerId, Collections.emptySet());
        return subscriptions.contains(subscription);
    }

    @Override
    public Map<SubscriptionName, Set<String>> getSubscriptionConsumers() {
        HashMap<SubscriptionName, Set<String>> result = new HashMap<SubscriptionName, Set<String>>();
        this.consumerSubscriptions.forEach((consumer, subscriptions) -> subscriptions.forEach(subscription -> {
            if (result.containsKey(subscription)) {
                ((Set)result.get(subscription)).add(consumer);
            } else {
                HashSet<String> consumers = new HashSet<String>();
                consumers.add((String)consumer);
                result.put((SubscriptionName)subscription, (Set<String>)consumers);
            }
        }));
        return result;
    }

    @Override
    public Set<String> getAssignedConsumers() {
        return this.consumerSubscriptions.keySet();
    }

    @Override
    public Set<SubscriptionName> getConsumerSubscriptions(String consumerId) {
        return this.consumerSubscriptions.getOrDefault(consumerId, Collections.emptySet());
    }
}

