/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.filtering.json;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.filtering.FilteringException;
import pl.allegro.tech.hermes.consumers.consumer.filtering.MatchingStrategy;
import pl.allegro.tech.hermes.consumers.consumer.filtering.UnsupportedMatchingStrategyException;

public class JsonPathPredicate
implements Predicate<Message> {
    private Configuration configuration;
    private String path;
    private Pattern matcher;
    private MatchingStrategy matchingStrategy;

    public JsonPathPredicate(String path, Pattern matcher, Configuration configuration) {
        this(path, matcher, configuration, MatchingStrategy.ALL);
    }

    public JsonPathPredicate(String path, Pattern matcher, Configuration configuration, MatchingStrategy matchingStrategy) {
        this.path = path;
        this.matcher = matcher;
        this.configuration = configuration;
        this.matchingStrategy = matchingStrategy;
    }

    @Override
    public boolean test(Message message) {
        FilteringException.check(message.getContentType() == ContentType.JSON, "This filter supports only JSON contentType.");
        try {
            List result = (List)JsonPath.parse((InputStream)new ByteArrayInputStream(message.getData()), (Configuration)this.configuration).read(this.path, new com.jayway.jsonpath.Predicate[0]);
            Stream<String> resultStream = result.stream().map(Object::toString);
            return !result.isEmpty() && this.matchResultsStream(resultStream);
        }
        catch (Exception ex) {
            throw new FilteringException(ex);
        }
    }

    private boolean matchResultsStream(Stream<String> results) {
        switch (this.matchingStrategy) {
            case ALL: {
                return results.allMatch(this::matches);
            }
            case ANY: {
                return results.anyMatch(this::matches);
            }
        }
        throw new UnsupportedMatchingStrategyException("avropath", this.matchingStrategy);
    }

    private boolean matches(String value) {
        return this.matcher.matcher(value).matches();
    }
}

