/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.oauth.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.entity.ContentType;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import pl.allegro.tech.hermes.consumers.consumer.oauth.OAuthAccessToken;
import pl.allegro.tech.hermes.consumers.consumer.oauth.client.OAuthClient;
import pl.allegro.tech.hermes.consumers.consumer.oauth.client.OAuthTokenRequest;
import pl.allegro.tech.hermes.consumers.consumer.oauth.client.OAuthTokenRequestException;
import pl.allegro.tech.hermes.consumers.consumer.oauth.client.OAuthTokenResponse;

public class OAuthHttpClient
implements OAuthClient {
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;

    @Inject
    public OAuthHttpClient(@Named(value="oauth-http-client") HttpClient httpClient, ObjectMapper objectMapper) {
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    @Override
    public OAuthAccessToken getToken(OAuthTokenRequest request) {
        ContentResponse response = this.performHttpRequest(request);
        this.validateHttpResponse(response);
        OAuthTokenResponse accessTokenResponse = this.httpResponseToOAuthAccessTokenResponse(response);
        return accessTokenResponse.toAccessToken();
    }

    private Request createHttpRequest(OAuthTokenRequest request) {
        Request httpRequest = this.httpClient.newRequest(request.getUrl()).timeout((long)request.getRequestTimeout().intValue(), TimeUnit.MILLISECONDS).idleTimeout((long)request.getSocketTimeout().intValue(), TimeUnit.MILLISECONDS).method(HttpMethod.POST).header(HttpHeader.KEEP_ALIVE, "true").header(HttpHeader.CONTENT_TYPE, ContentType.APPLICATION_FORM_URLENCODED.toString()).param("grant_type", request.getGrantType()).param("scope", request.getScope()).param("client_id", request.getClientId()).param("client_secret", request.getClientSecret());
        if ("password".equals(request.getGrantType())) {
            httpRequest.param("username", request.getUsername()).param("password", request.getPassword());
        }
        return httpRequest;
    }

    private ContentResponse performHttpRequest(OAuthTokenRequest request) {
        try {
            return this.createHttpRequest(request).send();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new OAuthTokenRequestException("An exception occurred while performing token request", e);
        }
    }

    private void validateHttpResponse(ContentResponse response) {
        if (response.getStatus() != 200) {
            throw new OAuthTokenRequestException(String.format("%d %s response when performing token request", response.getStatus(), response.getContentAsString()));
        }
    }

    private OAuthTokenResponse httpResponseToOAuthAccessTokenResponse(ContentResponse response) {
        try {
            return (OAuthTokenResponse)this.objectMapper.readValue(response.getContentAsString(), OAuthTokenResponse.class);
        }
        catch (IOException e) {
            throw new OAuthTokenRequestException("An exception occurred while reading token response", e);
        }
    }

    @Override
    public void start() {
        try {
            this.httpClient.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void stop() {
        try {
            this.httpClient.stop();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

