/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.Iterator;
import java.util.Optional;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.consumers.consumer.Consumer;

public class ConsumerHolder
implements Iterable<Consumer> {
    private Table<TopicName, String, Consumer> consumers = HashBasedTable.create();

    public synchronized void add(TopicName topicName, String subscriptionName, Consumer consumer) {
        this.consumers.put((Object)topicName, (Object)subscriptionName, (Object)consumer);
    }

    public synchronized void remove(TopicName topicName, String subscriptionName) {
        this.consumers.remove((Object)topicName, (Object)subscriptionName);
    }

    public synchronized Optional<Consumer> get(TopicName topicName, String subscriptionName) {
        return Optional.ofNullable(this.consumers.get((Object)topicName, (Object)subscriptionName));
    }

    public synchronized boolean contains(TopicName topicName, String subscriptionName) {
        return this.consumers.contains((Object)topicName, (Object)subscriptionName);
    }

    @Override
    public synchronized Iterator<Consumer> iterator() {
        return Lists.newArrayList((Iterable)this.consumers.values()).iterator();
    }

    public synchronized void clear() {
        this.consumers.clear();
    }
}

