/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.oauth;

import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class OAuthTokenRequestRateLimiter {
    private final double initialRate;
    private final double minimalRate;
    private final double rateReductionFactor;
    private final RateLimiter rateLimiter;
    private final AtomicInteger rateReductionsCount = new AtomicInteger();

    public OAuthTokenRequestRateLimiter(double initialRate, double minimalRate, double rateReductionFactor, long warmUpPeriod) {
        this.initialRate = initialRate;
        this.rateLimiter = RateLimiter.create((double)initialRate, (long)warmUpPeriod, (TimeUnit)TimeUnit.MILLISECONDS);
        this.minimalRate = minimalRate;
        this.rateReductionFactor = rateReductionFactor;
    }

    public boolean tryAcquire() {
        return this.rateLimiter.tryAcquire();
    }

    public void reduceRate() {
        this.rateReductionsCount.incrementAndGet();
        this.rateLimiter.setRate(Math.max(this.rateLimiter.getRate() / this.rateReductionFactor, this.minimalRate));
    }

    public void resetRate() {
        if (this.rateReductionsCount.get() > 0) {
            this.rateLimiter.setRate(this.initialRate);
            this.rateReductionsCount.set(0);
        }
    }

    public double getCurrentRate() {
        return this.rateLimiter.getRate();
    }
}

