/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.selective;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignment;
import pl.allegro.tech.hermes.consumers.supervisor.workload.SubscriptionAssignmentView;
import pl.allegro.tech.hermes.domain.workload.constraints.WorkloadConstraints;

public class AvailableWork
extends Spliterators.AbstractSpliterator<SubscriptionAssignment> {
    private SubscriptionAssignmentView state;
    private final WorkloadConstraints constraints;

    private AvailableWork(SubscriptionAssignmentView state, WorkloadConstraints constraints) {
        super(Long.MAX_VALUE, 0);
        this.state = state;
        this.constraints = constraints;
    }

    @Override
    public boolean tryAdvance(Consumer<? super SubscriptionAssignment> action) {
        Optional<SubscriptionAssignment> subscriptionAssignment;
        Set<String> availableConsumers = this.availableConsumerNodes(this.state);
        if (!availableConsumers.isEmpty() && (subscriptionAssignment = this.getNextSubscription(this.state, availableConsumers).map(subscription -> this.getNextSubscriptionAssignment(this.state, availableConsumers, (SubscriptionName)subscription))).isPresent()) {
            action.accept(subscriptionAssignment.get());
            return true;
        }
        return false;
    }

    private Optional<SubscriptionName> getNextSubscription(SubscriptionAssignmentView state, Set<String> availableConsumerNodes) {
        return state.getSubscriptions().stream().filter(s -> state.getAssignmentsCountForSubscription((SubscriptionName)s) < this.constraints.getConsumersNumber(s)).filter(s -> !Sets.difference((Set)availableConsumerNodes, state.getConsumerNodesForSubscription((SubscriptionName)s)).isEmpty()).min(Comparator.comparingInt(state::getAssignmentsCountForSubscription));
    }

    private SubscriptionAssignment getNextSubscriptionAssignment(SubscriptionAssignmentView state, Set<String> availableConsumerNodes, SubscriptionName subscriptionName) {
        return availableConsumerNodes.stream().filter(s -> !state.getSubscriptionsForConsumerNode((String)s).contains(subscriptionName)).min(Comparator.comparingInt(state::getAssignmentsCountForConsumerNode)).map(s -> new SubscriptionAssignment((String)s, subscriptionName)).get();
    }

    private Set<String> availableConsumerNodes(SubscriptionAssignmentView state) {
        return state.getConsumerNodes().stream().filter(s -> state.getAssignmentsCountForConsumerNode((String)s) < this.constraints.getMaxSubscriptionsPerConsumer()).filter(s -> state.getAssignmentsCountForConsumerNode((String)s) < state.getSubscriptionsCount()).collect(Collectors.toSet());
    }

    public static Stream<SubscriptionAssignment> stream(SubscriptionAssignmentView state, WorkloadConstraints constraints) {
        AvailableWork work = new AvailableWork(state, constraints);
        return StreamSupport.stream(work, false);
    }
}

