/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.subscription.id;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionId;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIdProvider;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIds;
import pl.allegro.tech.hermes.domain.notifications.InternalNotificationsBus;
import pl.allegro.tech.hermes.domain.notifications.SubscriptionCallback;

public class NotificationAwareSubscriptionIdsCache
implements SubscriptionIds,
SubscriptionCallback {
    private static final Logger logger = LoggerFactory.getLogger(NotificationAwareSubscriptionIdsCache.class);
    private final SubscriptionsCache subscriptionsCache;
    private final SubscriptionIdProvider subscriptionIdProvider;
    private final Map<SubscriptionName, SubscriptionId> nameToIdMap = new ConcurrentHashMap<SubscriptionName, SubscriptionId>();
    private final Map<Long, SubscriptionId> valueToIdMap = new ConcurrentHashMap<Long, SubscriptionId>();
    private final Cache<SubscriptionName, SubscriptionId> nameToIdMapOfRemoved;
    private final Cache<Long, SubscriptionId> valueToIdMapOfRemoved;

    public NotificationAwareSubscriptionIdsCache(InternalNotificationsBus notificationsBus, SubscriptionsCache subscriptionsCache, SubscriptionIdProvider subscriptionIdProvider, long removedSubscriptionsExpireAfterAccessSeconds, Ticker ticker) {
        this.subscriptionsCache = subscriptionsCache;
        this.subscriptionIdProvider = subscriptionIdProvider;
        this.nameToIdMapOfRemoved = this.createExpiringCache(removedSubscriptionsExpireAfterAccessSeconds, ticker, notification -> logger.info("Removing expired subscription {} id from name->id cache", (Object)((SubscriptionName)notification.getKey()).getQualifiedName()));
        this.valueToIdMapOfRemoved = this.createExpiringCache(removedSubscriptionsExpireAfterAccessSeconds, ticker, notification -> logger.info("Removing expired subscription {} id from value->id cache", (Object)((SubscriptionId)notification.getValue()).getSubscriptionName().getQualifiedName()));
        notificationsBus.registerSubscriptionCallback((SubscriptionCallback)this);
    }

    private <K, V> Cache<K, V> createExpiringCache(long expireAfterSeconds, Ticker ticker, RemovalListener<K, V> removalListener) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterAccess(expireAfterSeconds, TimeUnit.SECONDS).ticker(ticker).removalListener(removalListener);
        return cacheBuilder.build();
    }

    @Override
    public void start() {
        this.subscriptionsCache.listActiveSubscriptionNames().forEach(this::putSubscriptionId);
    }

    private void putSubscriptionId(SubscriptionName name) {
        SubscriptionId id = this.subscriptionIdProvider.getSubscriptionId(name);
        this.nameToIdMap.put(name, id);
        this.valueToIdMap.put(id.getValue(), id);
    }

    @Override
    public Optional<SubscriptionId> getSubscriptionId(SubscriptionName subscriptionName) {
        return Optional.ofNullable(Optional.ofNullable(this.nameToIdMap.get(subscriptionName)).orElseGet(() -> (SubscriptionId)this.nameToIdMapOfRemoved.getIfPresent((Object)subscriptionName)));
    }

    @Override
    public Optional<SubscriptionId> getSubscriptionId(long id) {
        return Optional.ofNullable(Optional.ofNullable(this.valueToIdMap.get(id)).orElseGet(() -> (SubscriptionId)this.valueToIdMapOfRemoved.getIfPresent((Object)id)));
    }

    public void onSubscriptionCreated(Subscription subscription) {
        this.putSubscriptionId(subscription.getQualifiedName());
    }

    public void onSubscriptionChanged(Subscription subscription) {
        this.putSubscriptionId(subscription.getQualifiedName());
    }

    public void onSubscriptionRemoved(Subscription subscription) {
        Optional.ofNullable(this.nameToIdMap.remove(subscription.getQualifiedName())).ifPresent(id -> {
            this.valueToIdMap.remove(id.getValue());
            this.nameToIdMapOfRemoved.put((Object)subscription.getQualifiedName(), id);
            this.valueToIdMapOfRemoved.put((Object)id.getValue(), id);
        });
    }
}

