/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import javax.inject.Inject;
import org.apache.curator.framework.CuratorFramework;
import org.glassfish.hk2.api.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIds;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ConsumerAssignmentCache;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ConsumerWorkloadRegistryType;
import pl.allegro.tech.hermes.consumers.supervisor.workload.FlatBinaryConsumerAssignmentCache;
import pl.allegro.tech.hermes.consumers.supervisor.workload.HierarchicalConsumerAssignmentCache;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;

public class ConsumerAssignmentCacheFactory
implements Factory<ConsumerAssignmentCache> {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerAssignmentCacheFactory.class);
    private final CuratorFramework curator;
    private final ConfigFactory configFactory;
    private final ZookeeperPaths zookeeperPaths;
    private final SubscriptionsCache subscriptionsCache;
    private final SubscriptionIds subscriptionIds;

    @Inject
    public ConsumerAssignmentCacheFactory(CuratorFramework curator, ConfigFactory configFactory, ZookeeperPaths zookeeperPaths, SubscriptionsCache subscriptionsCache, SubscriptionIds subscriptionIds) {
        this.curator = curator;
        this.configFactory = configFactory;
        this.zookeeperPaths = zookeeperPaths;
        this.subscriptionsCache = subscriptionsCache;
        this.subscriptionIds = subscriptionIds;
    }

    public ConsumerAssignmentCache provide() {
        ConsumerWorkloadRegistryType type;
        try {
            String typeString = this.configFactory.getStringProperty(Configs.CONSUMER_WORKLOAD_REGISTRY_TYPE);
            type = ConsumerWorkloadRegistryType.fromString(typeString);
        }
        catch (Exception e) {
            logger.error("Could not configure consumer assignment notifying cache based on specified consumer workload registry type", (Throwable)e);
            throw e;
        }
        String consumerId = this.configFactory.getStringProperty(Configs.CONSUMER_WORKLOAD_NODE_ID);
        String clusterName = this.configFactory.getStringProperty(Configs.KAFKA_CLUSTER_NAME);
        switch (type) {
            case HIERARCHICAL: {
                return new HierarchicalConsumerAssignmentCache(this.curator, consumerId, clusterName, this.zookeeperPaths, this.subscriptionsCache);
            }
            case FLAT_BINARY: {
                return new FlatBinaryConsumerAssignmentCache(this.curator, consumerId, clusterName, this.zookeeperPaths, this.subscriptionIds);
            }
        }
        throw new UnsupportedOperationException("Workload registry type not supported.");
    }

    public void dispose(ConsumerAssignmentCache instance) {
    }
}

