/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.api.Request;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.MultiMessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.SingleMessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.HttpRequestData;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.HttpRequestFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.SendingResultHandlers;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.HttpHeadersProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.HttpRequestHeaders;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolutionException;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.ResolvableEndpointAddress;

public class JettyBroadCastMessageSender
implements MessageSender {
    private final HttpRequestFactory requestFactory;
    private final ResolvableEndpointAddress endpoint;
    private final HttpHeadersProvider requestHeadersProvider;
    private final SendingResultHandlers sendingResultHandlers;

    public JettyBroadCastMessageSender(HttpRequestFactory requestFactory, ResolvableEndpointAddress endpoint, HttpHeadersProvider requestHeadersProvider, SendingResultHandlers sendingResultHandlers) {
        this.requestFactory = requestFactory;
        this.endpoint = endpoint;
        this.requestHeadersProvider = requestHeadersProvider;
        this.sendingResultHandlers = sendingResultHandlers;
    }

    @Override
    public CompletableFuture<MessageSendingResult> send(Message message) {
        try {
            return this.sendMessage(message).thenApply(MultiMessageSendingResult::new);
        }
        catch (Exception exception) {
            return CompletableFuture.completedFuture(MessageSendingResult.failedResult(exception));
        }
    }

    private CompletableFuture<List<SingleMessageSendingResult>> sendMessage(Message message) {
        try {
            List<CompletableFuture<SingleMessageSendingResult>> results = this.collectResults(message);
            return this.mergeResults(results);
        }
        catch (EndpointAddressResolutionException exception) {
            return CompletableFuture.completedFuture(Collections.singletonList(MessageSendingResult.failedResult(exception)));
        }
    }

    private List<CompletableFuture<SingleMessageSendingResult>> collectResults(Message message) throws EndpointAddressResolutionException {
        HttpRequestData requestData = new HttpRequestData.HttpRequestDataBuilder().withRawAddress(this.endpoint.getRawAddress()).build();
        HttpRequestHeaders headers = this.requestHeadersProvider.getHeaders(message, requestData);
        return this.endpoint.resolveAllFor(message).stream().filter(uri -> message.hasNotBeenSentTo(uri.toString())).map(uri -> this.requestFactory.buildRequest(message, (URI)uri, headers)).map(this::processResponse).collect(Collectors.toList());
    }

    private CompletableFuture<List<SingleMessageSendingResult>> mergeResults(List<CompletableFuture<SingleMessageSendingResult>> results) {
        return CompletableFuture.allOf(results.toArray(new CompletableFuture[results.size()])).thenApply(v -> results.stream().map(CompletableFuture::join).reduce(ImmutableList.builder(), (builder, element) -> builder.add(element), (listA, listB) -> listA.addAll((Iterable)listB.build())).build());
    }

    private CompletableFuture<SingleMessageSendingResult> processResponse(Request request) {
        CompletableFuture<SingleMessageSendingResult> resultFuture = new CompletableFuture<SingleMessageSendingResult>();
        request.send(this.sendingResultHandlers.handleSendingResultForBroadcast(resultFuture));
        return resultFuture;
    }

    @Override
    public void stop() {
    }
}

