/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.jms;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.Message;
import pl.allegro.tech.hermes.api.EndpointAddress;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.jms.JmsMessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.jms.JmsMessageSenderProvider;
import pl.allegro.tech.hermes.consumers.consumer.trace.MetadataAppender;
import pl.allegro.tech.hermes.consumers.uri.UriUtils;

public abstract class AbstractJmsMessageSenderProvider
implements JmsMessageSenderProvider {
    protected final ConfigFactory configFactory;
    protected final LoadingCache<URI, ConnectionFactory> connectionFactoryCache;
    protected final MetadataAppender<Message> metadataAppender;

    public AbstractJmsMessageSenderProvider(ConfigFactory configFactory, MetadataAppender<Message> metadataAppender) {
        this.configFactory = configFactory;
        this.connectionFactoryCache = CacheBuilder.newBuilder().build((CacheLoader)new ConnectionFactoryLoader());
        this.metadataAppender = metadataAppender;
    }

    @Override
    public MessageSender create(Subscription subscription) {
        EndpointAddress endpoint = subscription.getEndpoint();
        URI uri = endpoint.getUri();
        ConnectionFactory connectionFactory = this.getConnectionFactory(uri);
        JMSContext jmsContext = connectionFactory.createContext(endpoint.getUsername(), endpoint.getPassword());
        return new JmsMessageSender(jmsContext, this.extractTopicName(uri), this.metadataAppender);
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
        this.connectionFactoryCache.invalidateAll();
    }

    private ConnectionFactory getConnectionFactory(URI serverUri) {
        try {
            return (ConnectionFactory)this.connectionFactoryCache.get((Object)serverUri);
        }
        catch (ExecutionException e) {
            throw new InternalProcessingException(String.format("Unable to create connection factory for url %s", serverUri), (Throwable)e);
        }
    }

    private String extractTopicName(URI endpointURI) {
        return UriUtils.extractContextFromUri(endpointURI).replaceFirst("/", "");
    }

    protected class ConnectionFactoryLoader
    extends CacheLoader<URI, ConnectionFactory> {
        protected ConnectionFactoryLoader() {
        }

        public ConnectionFactory load(URI serverUri) throws Exception {
            return AbstractJmsMessageSenderProvider.this.createConnectionFactory(serverUri);
        }
    }
}

