/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.subscription.cache;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.domain.group.GroupRepository;
import pl.allegro.tech.hermes.domain.notifications.InternalNotificationsBus;
import pl.allegro.tech.hermes.domain.notifications.SubscriptionCallback;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;

public class NotificationsBasedSubscriptionCache
implements SubscriptionsCache,
SubscriptionCallback {
    private final Map<SubscriptionName, Subscription> subscriptions = new ConcurrentHashMap<SubscriptionName, Subscription>();
    private final GroupRepository groupRepository;
    private final TopicRepository topicRepository;
    private final SubscriptionRepository subscriptionRepository;

    public NotificationsBasedSubscriptionCache(InternalNotificationsBus notificationsBus, GroupRepository groupRepository, TopicRepository topicRepository, SubscriptionRepository subscriptionRepository) {
        notificationsBus.registerSubscriptionCallback((SubscriptionCallback)this);
        this.groupRepository = groupRepository;
        this.topicRepository = topicRepository;
        this.subscriptionRepository = subscriptionRepository;
    }

    public void onSubscriptionCreated(Subscription subscription) {
        this.subscriptions.put(subscription.getQualifiedName(), subscription);
    }

    public void onSubscriptionRemoved(Subscription subscription) {
        this.subscriptions.remove(subscription.getQualifiedName(), subscription);
    }

    public void onSubscriptionChanged(Subscription subscription) {
        this.subscriptions.put(subscription.getQualifiedName(), subscription);
    }

    @Override
    public Subscription getSubscription(SubscriptionName subscriptionName) {
        return this.subscriptions.get(subscriptionName);
    }

    @Override
    public List<Subscription> subscriptionsOfTopic(TopicName topicName) {
        return this.subscriptions.values().stream().filter(s -> s.getTopicName().equals((Object)topicName)).collect(Collectors.toList());
    }

    @Override
    public List<SubscriptionName> listActiveSubscriptionNames() {
        return this.subscriptions.values().stream().filter(Subscription::isActive).map(Subscription::getQualifiedName).collect(Collectors.toList());
    }

    @Override
    public void start() {
        for (String groupName : this.groupRepository.listGroupNames()) {
            for (String topicName : this.topicRepository.listTopicNames(groupName)) {
                for (Subscription subscription : this.subscriptionRepository.listSubscriptions(new TopicName(groupName, topicName))) {
                    this.subscriptions.put(subscription.getQualifiedName(), subscription);
                }
            }
        }
    }
}

