/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.offset.kafka.broker;

import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.kafka.offset.PartitionOffset;

public class KafkaConsumerOffsetMover {
    private static final Logger logger = LoggerFactory.getLogger(KafkaConsumerOffsetMover.class);
    private final SubscriptionName subscriptionName;
    private KafkaConsumer consumer;

    public KafkaConsumerOffsetMover(SubscriptionName subscriptionName, KafkaConsumer consumer) {
        this.subscriptionName = subscriptionName;
        this.consumer = consumer;
    }

    public boolean move(PartitionOffset offset) {
        try {
            TopicPartition tp = new TopicPartition(offset.getTopic().asString(), offset.getPartition());
            if (this.consumer.assignment().contains(tp)) {
                logger.info("Moving offset for assigned partition {} on subscription {}", (Object)offset.getPartition(), (Object)this.subscriptionName);
                this.consumer.seek(tp, offset.getOffset());
                return true;
            }
            logger.info("Not assigned to partition {} on subscription {}", (Object)offset.getPartition(), (Object)this.subscriptionName);
            return false;
        }
        catch (IllegalStateException ex) {
            logger.error("Failed to move offset for subscription={}, partition={}, offset={}", new Object[]{this.subscriptionName, offset.getPartition(), offset.getOffset(), ex});
            return false;
        }
    }
}

