/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.maxrate;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.inject.Inject;
import org.apache.curator.framework.CuratorFramework;
import org.glassfish.hk2.api.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.ConsumerMaxRateRegistryType;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.FlatBinaryMaxRateRegistry;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.HierarchicalCacheMaxRateRegistry;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRatePathSerializer;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateRegistry;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIds;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ClusterAssignmentCache;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ConsumerAssignmentCache;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;

public class MaxRateRegistryFactory
implements Factory<MaxRateRegistry> {
    private static final Logger logger = LoggerFactory.getLogger(MaxRateRegistryFactory.class);
    private final ConfigFactory configFactory;
    private final CuratorFramework curator;
    private final ObjectMapper objectMapper;
    private final ZookeeperPaths zookeeperPaths;
    private final MaxRatePathSerializer pathSerializer;
    private final SubscriptionsCache subscriptionCache;
    private final SubscriptionIds subscriptionIds;
    private final ConsumerAssignmentCache assignmentCache;
    private final ClusterAssignmentCache clusterAssignmentCache;

    @Inject
    public MaxRateRegistryFactory(ConfigFactory configFactory, CuratorFramework curator, ObjectMapper objectMapper, ZookeeperPaths zookeeperPaths, MaxRatePathSerializer pathSerializer, SubscriptionsCache subscriptionCache, SubscriptionIds subscriptionIds, ConsumerAssignmentCache assignmentCache, ClusterAssignmentCache clusterAssignmentCache) {
        this.configFactory = configFactory;
        this.curator = curator;
        this.objectMapper = objectMapper;
        this.zookeeperPaths = zookeeperPaths;
        this.pathSerializer = pathSerializer;
        this.subscriptionCache = subscriptionCache;
        this.subscriptionIds = subscriptionIds;
        this.assignmentCache = assignmentCache;
        this.clusterAssignmentCache = clusterAssignmentCache;
    }

    public MaxRateRegistry provide() {
        ConsumerMaxRateRegistryType type;
        try {
            String typeString = this.configFactory.getStringProperty(Configs.CONSUMER_MAXRATE_REGISTRY_TYPE);
            type = ConsumerMaxRateRegistryType.fromString(typeString);
        }
        catch (Exception e) {
            logger.error("Could not configure max rate registry", (Throwable)e);
            throw e;
        }
        logger.info("Max rate registry type chosen: {}", (Object)type.getConfigValue());
        switch (type) {
            case HIERARCHICAL: {
                return new HierarchicalCacheMaxRateRegistry(this.configFactory, this.curator, this.objectMapper, this.zookeeperPaths, this.pathSerializer, this.subscriptionCache);
            }
            case FLAT_BINARY: {
                return new FlatBinaryMaxRateRegistry(this.configFactory, this.clusterAssignmentCache, this.assignmentCache, this.curator, this.zookeeperPaths, this.subscriptionIds);
            }
        }
        throw new UnsupportedOperationException("Max-rate type not supported.");
    }

    public void dispose(MaxRateRegistry instance) {
    }
}

