/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.result;

import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.message.MessageConverter;
import pl.allegro.tech.hermes.consumers.consumer.offset.OffsetQueue;
import pl.allegro.tech.hermes.consumers.consumer.offset.SubscriptionPartitionOffset;
import pl.allegro.tech.hermes.consumers.consumer.result.AbstractHandler;
import pl.allegro.tech.hermes.consumers.consumer.result.SuccessHandler;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.tracker.consumers.Trackers;

public class DefaultSuccessHandler
extends AbstractHandler
implements SuccessHandler {
    private final Trackers trackers;

    public DefaultSuccessHandler(OffsetQueue offsetQueue, HermesMetrics hermesMetrics, Trackers trackers) {
        super(offsetQueue, hermesMetrics);
        this.trackers = trackers;
    }

    @Override
    public void handleSuccess(Message message, Subscription subscription, MessageSendingResult result) {
        this.offsetQueue.offerCommittedOffset(SubscriptionPartitionOffset.subscriptionPartitionOffset(subscription.getQualifiedName(), message.getPartitionOffset(), message.getPartitionAssignmentTerm()));
        this.updateMeters(message, subscription, result);
        this.updateMetrics("delivered.$group.$topic.$subscription", message, subscription);
        this.trackers.get(subscription).logSent(MessageConverter.toMessageMetadata(message, subscription), result.getHostname());
    }

    private void updateMeters(Message message, Subscription subscription, MessageSendingResult result) {
        this.hermesMetrics.meter("meter").mark();
        this.hermesMetrics.meter("meter.$group.$topic", subscription.getTopicName()).mark();
        this.hermesMetrics.meter("meter.$group.$topic.$subscription", subscription.getTopicName(), subscription.getName()).mark();
        this.hermesMetrics.meter("throughput.$group.$topic.$subscription", subscription.getTopicName(), subscription.getName()).mark(message.getSize());
        this.hermesMetrics.registerConsumerHttpAnswer(subscription, result.getStatusCode());
    }
}

