/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.process;

import java.time.Clock;
import java.util.function.Consumer;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.supervisor.ConsumerFactory;
import pl.allegro.tech.hermes.consumers.supervisor.process.ConsumerProcess;
import pl.allegro.tech.hermes.consumers.supervisor.process.ConsumerProcessSupplier;
import pl.allegro.tech.hermes.consumers.supervisor.process.Retransmitter;
import pl.allegro.tech.hermes.consumers.supervisor.process.Signal;

public class ConsumerProcessFactory
implements ConsumerProcessSupplier {
    private final Retransmitter retransmitter;
    private final long unhealthyAfter;
    private final Clock clock;
    private final ConsumerFactory consumerFactory;

    public ConsumerProcessFactory(Retransmitter retransmitter, ConsumerFactory consumerFactory, ConfigFactory configs, Clock clock) {
        this.retransmitter = retransmitter;
        this.consumerFactory = consumerFactory;
        this.unhealthyAfter = configs.getIntProperty(Configs.CONSUMER_BACKGROUND_SUPERVISOR_UNHEALTHY_AFTER);
        this.clock = clock;
    }

    @Override
    public ConsumerProcess createProcess(Subscription subscription, Signal startSignal, Consumer<SubscriptionName> onConsumerStopped) {
        return new ConsumerProcess(startSignal, this.consumerFactory.createConsumer(subscription), this.retransmitter, this.clock, this.unhealthyAfter, onConsumerStopped);
    }
}

