/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.registry;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Clock;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import org.apache.curator.framework.CuratorFramework;
import org.glassfish.hk2.api.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.registry.ConsumerNodesRegistry;
import pl.allegro.tech.hermes.consumers.registry.ConsumerNodesRegistryPaths;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;

public class ConsumerNodesRegistryFactory
implements Factory<ConsumerNodesRegistry> {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerNodesRegistryFactory.class);
    private final CuratorFramework curatorFramework;
    private final ConfigFactory configFactory;
    private final ZookeeperPaths zookeeperPaths;
    private final Clock clock;

    @Inject
    public ConsumerNodesRegistryFactory(CuratorFramework curatorFramework, ConfigFactory configFactory, ZookeeperPaths zookeeperPaths, Clock clock) {
        this.curatorFramework = curatorFramework;
        this.configFactory = configFactory;
        this.zookeeperPaths = zookeeperPaths;
        this.clock = clock;
    }

    public ConsumerNodesRegistry provide() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("ConsumerRegistryExecutor-%d").build();
        String clusterName = this.configFactory.getStringProperty(Configs.KAFKA_CLUSTER_NAME);
        String consumerNodeId = this.configFactory.getStringProperty(Configs.CONSUMER_WORKLOAD_NODE_ID);
        int deadAfterSeconds = this.configFactory.getIntProperty(Configs.CONSUMER_WORKLOAD_DEAD_AFTER_SECONDS);
        ConsumerNodesRegistryPaths registryPaths = new ConsumerNodesRegistryPaths(this.zookeeperPaths, clusterName);
        return new ConsumerNodesRegistry(this.curatorFramework, Executors.newSingleThreadExecutor(threadFactory), registryPaths, consumerNodeId, deadAfterSeconds, this.clock);
    }

    public void dispose(ConsumerNodesRegistry instance) {
    }
}

