/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.jvnet.hk2.component.MultiMap;
import pl.allegro.tech.hermes.common.di.CommonBinder;
import pl.allegro.tech.hermes.common.hook.Hook;
import pl.allegro.tech.hermes.common.hook.HooksHandler;
import pl.allegro.tech.hermes.common.hook.ServiceAwareHook;
import pl.allegro.tech.hermes.common.kafka.KafkaNamesMapper;
import pl.allegro.tech.hermes.consumers.HermesConsumers;
import pl.allegro.tech.hermes.consumers.consumer.receiver.kafka.MessageContentReaderFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.ProtocolMessageSenderProvider;
import pl.allegro.tech.hermes.consumers.di.ConsumersBinder;
import pl.allegro.tech.hermes.consumers.di.TrackersBinder;
import pl.allegro.tech.hermes.domain.filtering.MessageFilter;
import pl.allegro.tech.hermes.domain.filtering.MessageFilterSource;
import pl.allegro.tech.hermes.domain.filtering.MessageFilters;
import pl.allegro.tech.hermes.domain.filtering.SubscriptionMessageFilterCompiler;
import pl.allegro.tech.hermes.domain.filtering.avro.AvroPathSubscriptionMessageFilterCompiler;
import pl.allegro.tech.hermes.domain.filtering.header.HeaderSubscriptionMessageFilterCompiler;
import pl.allegro.tech.hermes.domain.filtering.json.JsonPathSubscriptionMessageFilterCompiler;
import pl.allegro.tech.hermes.tracker.consumers.LogRepository;

public final class HermesConsumersBuilder {
    private static final int RANK_HIGHER_THAN_DEFAULT = 10;
    private final HooksHandler hooksHandler = new HooksHandler();
    private final MultiMap<String, Function<ServiceLocator, ProtocolMessageSenderProvider>> messageSenderProviders = new MultiMap();
    private final List<Function<ServiceLocator, LogRepository>> logRepositories = new ArrayList<Function<ServiceLocator, LogRepository>>();
    private final List<SubscriptionMessageFilterCompiler> filters = new ArrayList<SubscriptionMessageFilterCompiler>();
    private final List<MessageFilter> globalFilters = new ArrayList<MessageFilter>();
    private boolean flushLogsShutdownHookEnabled = true;
    private final List<Binder> binders = Lists.newArrayList((Object[])new Binder[]{new CommonBinder(), new ConsumersBinder()});

    public HermesConsumersBuilder withStartupHook(ServiceAwareHook hook) {
        this.hooksHandler.addStartupHook(hook);
        return this;
    }

    public HermesConsumersBuilder withStartupHook(Hook hook) {
        return this.withStartupHook(s -> hook.apply());
    }

    public HermesConsumersBuilder withShutdownHook(ServiceAwareHook hook) {
        this.hooksHandler.addShutdownHook(hook);
        return this;
    }

    public HermesConsumersBuilder withShutdownHook(Hook hook) {
        return this.withShutdownHook(s -> hook.apply());
    }

    public HermesConsumersBuilder withDisabledGlobalShutdownHook() {
        this.hooksHandler.disableGlobalShutdownHook();
        return this;
    }

    public HermesConsumersBuilder withDisabledFlushLogsShutdownHook() {
        this.flushLogsShutdownHookEnabled = false;
        return this;
    }

    public HermesConsumersBuilder withMessageSenderProvider(String protocol, Supplier<ProtocolMessageSenderProvider> messageSenderProviderSupplier) {
        this.messageSenderProviders.add((Object)protocol, s -> (ProtocolMessageSenderProvider)messageSenderProviderSupplier.get());
        return this;
    }

    public HermesConsumersBuilder withMessageSenderProvider(String protocol, Function<ServiceLocator, ProtocolMessageSenderProvider> messageSenderProviderSupplier) {
        this.messageSenderProviders.add((Object)protocol, messageSenderProviderSupplier);
        return this;
    }

    public HermesConsumersBuilder withLogRepository(Function<ServiceLocator, LogRepository> logRepository) {
        this.logRepositories.add(logRepository);
        return this;
    }

    public HermesConsumersBuilder withSubscriptionMessageFilter(SubscriptionMessageFilterCompiler filter) {
        this.filters.add(filter);
        return this;
    }

    public HermesConsumersBuilder withGlobalMessageFilter(MessageFilter filter) {
        this.globalFilters.add(filter);
        return this;
    }

    public HermesConsumersBuilder withKafkaTopicsNamesMapper(KafkaNamesMapper kafkaNamesMapper) {
        return this.withBinding(kafkaNamesMapper, KafkaNamesMapper.class);
    }

    public HermesConsumersBuilder withMessageContentReaderFactory(MessageContentReaderFactory messageContentReaderFactory) {
        return this.withBinding(messageContentReaderFactory, MessageContentReaderFactory.class);
    }

    public <T> HermesConsumersBuilder withBinding(T instance, Class<T> clazz) {
        return this.withBinding(instance, clazz, clazz.getName());
    }

    public <T> HermesConsumersBuilder withBinding(final T instance, final Class<T> clazz, final String name) {
        this.binders.add((Binder)new AbstractBinder(){

            protected void configure() {
                this.bind(instance).to(clazz).named(name).ranked(10);
            }
        });
        return this;
    }

    public HermesConsumers build() {
        this.withBinding(this.buildFilters(), MessageFilterSource.class);
        this.binders.add((Binder)new TrackersBinder(new ArrayList<LogRepository>()));
        this.messageSenderProviders.add((Object)"http", locator -> (ProtocolMessageSenderProvider)locator.getService(ProtocolMessageSenderProvider.class, "defaultHttpMessageSenderProvider", new Annotation[0]));
        this.messageSenderProviders.add((Object)"https", locator -> (ProtocolMessageSenderProvider)locator.getService(ProtocolMessageSenderProvider.class, "defaultHttpMessageSenderProvider", new Annotation[0]));
        this.messageSenderProviders.add((Object)"jms", locator -> (ProtocolMessageSenderProvider)locator.getService(ProtocolMessageSenderProvider.class, "defaultJmsMessageSenderProvider", new Annotation[0]));
        return new HermesConsumers(this.hooksHandler, this.binders, this.messageSenderProviders, this.logRepositories, this.flushLogsShutdownHookEnabled);
    }

    private MessageFilters buildFilters() {
        ArrayList<SubscriptionMessageFilterCompiler> availableFilters = new ArrayList<SubscriptionMessageFilterCompiler>(this.filters);
        availableFilters.add((SubscriptionMessageFilterCompiler)new JsonPathSubscriptionMessageFilterCompiler());
        availableFilters.add((SubscriptionMessageFilterCompiler)new AvroPathSubscriptionMessageFilterCompiler());
        availableFilters.add((SubscriptionMessageFilterCompiler)new HeaderSubscriptionMessageFilterCompiler());
        return new MessageFilters(this.globalFilters, availableFilters);
    }
}

