/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.maxrate;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.rate.SendCounters;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateProvider;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateRegistry;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateSupervisor;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.NegotiatedMaxRateProvider;

public class MaxRateProviderFactory {
    private final Creator providerCreator;

    @Inject
    public MaxRateProviderFactory(ConfigFactory configFactory, MaxRateRegistry maxRateRegistry, MaxRateSupervisor maxRateSupervisor, HermesMetrics metrics) {
        this.checkNegotiatedSettings(configFactory);
        this.providerCreator = (subscription, sendCounters) -> {
            String consumerId = configFactory.getStringProperty(Configs.CONSUMER_WORKLOAD_NODE_ID);
            int historyLimit = configFactory.getIntProperty(Configs.CONSUMER_MAXRATE_HISTORY_SIZE);
            double initialMaxRate = configFactory.getDoubleProperty(Configs.CONSUMER_MAXRATE_MIN_MAX_RATE);
            double minSignificantChange = configFactory.getDoubleProperty(Configs.CONSUMER_MAXRATE_MIN_SIGNIFICANT_UPDATE_PERCENT) / 100.0;
            return new NegotiatedMaxRateProvider(consumerId, maxRateRegistry, maxRateSupervisor, subscription, sendCounters, metrics, initialMaxRate, minSignificantChange, historyLimit);
        };
    }

    public MaxRateProvider create(Subscription subscription, SendCounters sendCounters) {
        return this.providerCreator.create(subscription, sendCounters);
    }

    private void checkNegotiatedSettings(ConfigFactory configFactory) {
        double minSignificantChange = configFactory.getDoubleProperty(Configs.CONSUMER_MAXRATE_MIN_SIGNIFICANT_UPDATE_PERCENT) / 100.0;
        double busyTolerance = configFactory.getDoubleProperty(Configs.CONSUMER_MAXRATE_BUSY_TOLERANCE);
        Preconditions.checkArgument((busyTolerance > minSignificantChange ? 1 : 0) != 0, (String)"Significant rate change (%s) can't be higher than busy tolerance (%s)", (Object)minSignificantChange, (Object)busyTolerance);
    }

    private static interface Creator {
        public MaxRateProvider create(Subscription var1, SendCounters var2);
    }
}

