/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import javax.inject.Inject;
import org.apache.curator.framework.CuratorFramework;
import org.glassfish.hk2.api.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.consumers.registry.ConsumerNodesRegistry;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIds;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ClusterAssignmentCache;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ConsumerAssignmentCache;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ConsumerWorkloadRegistryType;
import pl.allegro.tech.hermes.consumers.supervisor.workload.FlatBinaryClusterAssignmentCache;
import pl.allegro.tech.hermes.consumers.supervisor.workload.HierarchicalConsumerAssignmentCache;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;

public class ClusterAssignmentCacheFactory
implements Factory<ClusterAssignmentCache> {
    private static final Logger logger = LoggerFactory.getLogger(ClusterAssignmentCacheFactory.class);
    private final CuratorFramework curator;
    private final ConfigFactory configFactory;
    private final ConsumerAssignmentCache consumerAssignmentCache;
    private final ZookeeperPaths zookeeperPaths;
    private final SubscriptionIds subscriptionIds;
    private final ConsumerNodesRegistry consumerNodesRegistry;

    @Inject
    public ClusterAssignmentCacheFactory(CuratorFramework curator, ConfigFactory configFactory, ConsumerAssignmentCache consumerAssignmentCache, ZookeeperPaths zookeeperPaths, SubscriptionIds subscriptionIds, ConsumerNodesRegistry consumerNodesRegistry) {
        this.curator = curator;
        this.configFactory = configFactory;
        this.consumerAssignmentCache = consumerAssignmentCache;
        this.zookeeperPaths = zookeeperPaths;
        this.subscriptionIds = subscriptionIds;
        this.consumerNodesRegistry = consumerNodesRegistry;
    }

    public ClusterAssignmentCache provide() {
        ConsumerWorkloadRegistryType type;
        try {
            String typeString = this.configFactory.getStringProperty(Configs.CONSUMER_WORKLOAD_REGISTRY_TYPE);
            type = ConsumerWorkloadRegistryType.fromString(typeString);
        }
        catch (Exception e) {
            logger.error("Could not configure subscription assignment notifying repository based on specified consumer workload registry type", (Throwable)e);
            throw e;
        }
        String clusterName = this.configFactory.getStringProperty(Configs.KAFKA_CLUSTER_NAME);
        switch (type) {
            case HIERARCHICAL: {
                if (this.consumerAssignmentCache instanceof HierarchicalConsumerAssignmentCache) {
                    return (HierarchicalConsumerAssignmentCache)this.consumerAssignmentCache;
                }
                throw new IllegalStateException("Invalid type of HierarchicalConsumerAssignmentCache was registered for this type of workload registry");
            }
            case FLAT_BINARY: {
                return new FlatBinaryClusterAssignmentCache(this.curator, clusterName, this.zookeeperPaths, this.subscriptionIds, this.consumerNodesRegistry);
            }
        }
        throw new UnsupportedOperationException("Workload registry type not supported.");
    }

    public void dispose(ClusterAssignmentCache instance) {
    }
}

