/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.maxrate;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.RateHistory;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.SubscriptionIdMapper;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionId;

class ConsumerRateHistory {
    private final Map<SubscriptionName, RateHistory> rateHistories = new HashMap<SubscriptionName, RateHistory>();

    ConsumerRateHistory() {
    }

    RateHistory getRateHistory(SubscriptionName subscription) {
        return this.rateHistories.getOrDefault(subscription, RateHistory.empty());
    }

    void setRateHistory(SubscriptionName subscription, RateHistory rateHistory) {
        this.rateHistories.put(subscription, rateHistory);
    }

    void cleanup(Set<SubscriptionName> subscriptions) {
        this.rateHistories.entrySet().removeIf(entry -> !subscriptions.contains(entry.getKey()));
    }

    int size() {
        return this.rateHistories.size();
    }

    Map<SubscriptionId, RateHistory> toSubscriptionIdsMap(SubscriptionIdMapper subscriptionIdMapping) {
        return this.rateHistories.keySet().stream().map(subscriptionIdMapping::mapToSubscriptionId).filter(Optional::isPresent).collect(Collectors.toMap(Optional::get, subscriptionId -> this.rateHistories.get(((SubscriptionId)subscriptionId.get()).getSubscriptionName())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerRateHistory that = (ConsumerRateHistory)o;
        return Objects.equals(this.rateHistories, that.rateHistories);
    }

    public int hashCode() {
        return Objects.hash(this.rateHistories);
    }
}

