/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.offset;

import javax.inject.Inject;
import org.jctools.queues.MessagePassingQueue;
import pl.allegro.tech.hermes.common.config.ConfigFactory;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.offset.SubscriptionPartitionOffset;
import pl.allegro.tech.hermes.consumers.queue.FullDrainMpscQueue;
import pl.allegro.tech.hermes.consumers.queue.MonitoredMpscQueue;
import pl.allegro.tech.hermes.consumers.queue.MpscQueue;
import pl.allegro.tech.hermes.consumers.queue.WaitFreeDrainMpscQueue;

public class OffsetQueue {
    private final MpscQueue<SubscriptionPartitionOffset> inflightOffsetsQueue;
    private final MpscQueue<SubscriptionPartitionOffset> commitOffsetsQueue;

    @Inject
    public OffsetQueue(HermesMetrics metrics, ConfigFactory configFactory) {
        int queueSize = configFactory.getIntProperty(Configs.CONSUMER_COMMIT_OFFSET_QUEUES_SIZE);
        boolean fullDrainInflightsQueue = configFactory.getBooleanProperty(Configs.CONSUMER_COMMIT_OFFSET_QUEUES_INFLIGHT_DRAIN_FULL);
        this.inflightOffsetsQueue = new MonitoredMpscQueue<SubscriptionPartitionOffset>(fullDrainInflightsQueue ? new FullDrainMpscQueue(queueSize) : new WaitFreeDrainMpscQueue(queueSize), metrics, "inflightOffsets");
        this.commitOffsetsQueue = new MonitoredMpscQueue<SubscriptionPartitionOffset>(new WaitFreeDrainMpscQueue(queueSize), metrics, "committedOffsets");
    }

    public void offerInflightOffset(SubscriptionPartitionOffset offset) {
        this.inflightOffsetsQueue.offer(offset);
    }

    public void offerCommittedOffset(SubscriptionPartitionOffset offset) {
        this.commitOffsetsQueue.offer(offset);
    }

    public void drainInflightOffsets(MessagePassingQueue.Consumer<SubscriptionPartitionOffset> consumer) {
        this.inflightOffsetsQueue.drain(consumer);
    }

    public void drainCommittedOffsets(MessagePassingQueue.Consumer<SubscriptionPartitionOffset> consumer) {
        this.commitOffsetsQueue.drain(consumer);
    }
}

