/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.offset;

import java.util.Objects;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.kafka.KafkaTopicName;
import pl.allegro.tech.hermes.common.kafka.offset.PartitionOffset;
import pl.allegro.tech.hermes.consumers.consumer.offset.SubscriptionPartition;

public class SubscriptionPartitionOffset {
    private final SubscriptionPartition subscriptionPartition;
    private final long offset;

    public SubscriptionPartitionOffset(SubscriptionPartition subscriptionPartition, long offset) {
        this.subscriptionPartition = subscriptionPartition;
        this.offset = offset;
    }

    public static SubscriptionPartitionOffset subscriptionPartitionOffset(SubscriptionName subscriptionName, PartitionOffset partitionOffset, long partitionAssignmentTerm) {
        return new SubscriptionPartitionOffset(new SubscriptionPartition(partitionOffset.getTopic(), subscriptionName, partitionOffset.getPartition(), partitionAssignmentTerm), partitionOffset.getOffset());
    }

    public SubscriptionName getSubscriptionName() {
        return this.subscriptionPartition.getSubscriptionName();
    }

    public KafkaTopicName getKafkaTopicName() {
        return this.subscriptionPartition.getKafkaTopicName();
    }

    public int getPartition() {
        return this.subscriptionPartition.getPartition();
    }

    public long getOffset() {
        return this.offset;
    }

    public long getPartitionAssignmentTerm() {
        return this.subscriptionPartition.getPartitionAssignmentTerm();
    }

    public SubscriptionPartition getSubscriptionPartition() {
        return this.subscriptionPartition;
    }

    public String toString() {
        return "SubscriptionPartitionOffset{subscriptionPartition=" + this.subscriptionPartition + ", offset=" + this.offset + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionPartitionOffset that = (SubscriptionPartitionOffset)o;
        return this.offset == that.offset && Objects.equals(this.subscriptionPartition, that.subscriptionPartition);
    }

    public int hashCode() {
        return Objects.hash(this.subscriptionPartition, this.offset);
    }
}

