/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.EndpointAddress;
import pl.allegro.tech.hermes.api.EndpointAddressResolverMetadata;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionMode;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.ProtocolMessageSenderProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.Http2ClientHolder;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.HttpHeadersProvidersFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.HttpRequestFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.HttpRequestFactoryProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.JettyBroadCastMessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.JettyMessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.SendingResultHandlers;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.auth.HttpAuthorizationProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.auth.HttpAuthorizationProviderFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.AuthHeadersProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.HermesHeadersProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.Http1HeadersProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.Http2HeadersProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.HttpHeadersProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolver;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.ResolvableEndpointAddress;
import pl.allegro.tech.hermes.consumers.consumer.trace.MetadataAppender;

public class JettyHttpMessageSenderProvider
implements ProtocolMessageSenderProvider {
    private static final Logger logger = LoggerFactory.getLogger(JettyHttpMessageSenderProvider.class);
    private static final HttpHeadersProvider http1HeadersProvider = new Http1HeadersProvider();
    private static final HttpHeadersProvider http2HeadersProvider = new Http2HeadersProvider();
    private final HttpClient httpClient;
    private final Http2ClientHolder http2ClientHolder;
    private final EndpointAddressResolver endpointAddressResolver;
    private final MetadataAppender<Request> metadataAppender;
    private final HttpAuthorizationProviderFactory authorizationProviderFactory;
    private final HttpHeadersProvidersFactory httpHeadersProviderFactory;
    private final SendingResultHandlers sendingResultHandlers;
    private final HttpRequestFactoryProvider requestFactoryProvider;

    @Inject
    public JettyHttpMessageSenderProvider(@Named(value="http-1-client") HttpClient httpClient, Http2ClientHolder http2ClientHolder, EndpointAddressResolver endpointAddressResolver, MetadataAppender<Request> metadataAppender, HttpAuthorizationProviderFactory authorizationProviderFactory, HttpHeadersProvidersFactory httpHeadersProviderFactory, SendingResultHandlers sendingResultHandlers, HttpRequestFactoryProvider requestFactoryProvider) {
        this.httpClient = httpClient;
        this.http2ClientHolder = http2ClientHolder;
        this.endpointAddressResolver = endpointAddressResolver;
        this.metadataAppender = metadataAppender;
        this.authorizationProviderFactory = authorizationProviderFactory;
        this.httpHeadersProviderFactory = httpHeadersProviderFactory;
        this.sendingResultHandlers = sendingResultHandlers;
        this.requestFactoryProvider = requestFactoryProvider;
    }

    @Override
    public MessageSender create(Subscription subscription) {
        EndpointAddress endpoint = subscription.getEndpoint();
        EndpointAddressResolverMetadata endpointAddressResolverMetadata = subscription.getEndpointAddressResolverMetadata();
        ResolvableEndpointAddress resolvableEndpoint = new ResolvableEndpointAddress(endpoint, this.endpointAddressResolver, endpointAddressResolverMetadata);
        HttpRequestFactory requestFactory = this.requestFactoryProvider.provideRequestFactory(subscription, this.getHttpClient(subscription), this.metadataAppender);
        if (subscription.getMode() == SubscriptionMode.BROADCAST) {
            return new JettyBroadCastMessageSender(requestFactory, resolvableEndpoint, this.getHttpRequestHeadersProvider(subscription), this.sendingResultHandlers);
        }
        return new JettyMessageSender(requestFactory, resolvableEndpoint, this.getHttpRequestHeadersProvider(subscription), this.sendingResultHandlers);
    }

    private HttpHeadersProvider getHttpRequestHeadersProvider(Subscription subscription) {
        AuthHeadersProvider authProvider = this.getAuthHeadersProvider(subscription);
        Collection<HttpHeadersProvider> additionalProviders = this.httpHeadersProviderFactory.createAll();
        ImmutableSet providers = ImmutableSet.builder().addAll(additionalProviders).add((Object)authProvider).build();
        return new HermesHeadersProvider((Collection<HttpHeadersProvider>)providers);
    }

    private AuthHeadersProvider getAuthHeadersProvider(Subscription subscription) {
        Optional<HttpAuthorizationProvider> authorizationProvider = this.authorizationProviderFactory.create(subscription);
        HttpHeadersProvider httpHeadersProvider = subscription.isHttp2Enabled() ? http2HeadersProvider : http1HeadersProvider;
        return new AuthHeadersProvider(httpHeadersProvider, authorizationProvider.orElse(null));
    }

    private HttpClient getHttpClient(Subscription subscription) {
        if (subscription.isHttp2Enabled()) {
            return this.tryToGetHttp2Client(subscription);
        }
        logger.info("Using http/1.1 for {}.", (Object)subscription.getQualifiedName());
        return this.httpClient;
    }

    private HttpClient tryToGetHttp2Client(Subscription subscription) {
        if (this.http2ClientHolder.getHttp2Client().isPresent()) {
            logger.info("Using http/2 for {}.", (Object)subscription.getQualifiedName());
            return this.http2ClientHolder.getHttp2Client().get();
        }
        logger.info("Using http/1.1 for {}. Http/2 delivery is not enabled on this server.", (Object)subscription.getQualifiedName());
        return this.httpClient;
    }

    @Override
    public void start() throws Exception {
        this.startClient(this.httpClient);
        this.http2ClientHolder.getHttp2Client().ifPresent(this::startClient);
    }

    private void startClient(HttpClient client) {
        if (client.isStopped()) {
            try {
                client.start();
            }
            catch (Exception ex) {
                logger.error("Could not start http client.", (Throwable)ex);
            }
        }
    }

    @Override
    public void stop() throws Exception {
        this.stopClient(this.httpClient);
        this.http2ClientHolder.getHttp2Client().ifPresent(this::stopClient);
    }

    private void stopClient(HttpClient client) {
        if (client.isRunning()) {
            try {
                client.stop();
            }
            catch (Exception ex) {
                logger.error("Could not stop http client", (Throwable)ex);
            }
        }
    }
}

